/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.management;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.codehaus.jackson.map.ObjectMapper;

public class JobDefinitionQueryDto
extends AbstractQueryDto<JobDefinitionQuery> {
    private static final String SORT_BY_JOB_DEFINITION_ID = "jobDefinitionId";
    private static final String SORT_BY_ACTIVITY_ID = "activityId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String SORT_BY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    private static final String SORT_BY_JOB_TYPE = "jobType";
    private static final String SORT_BY_JOB_CONFIGURATION = "jobConfiguration";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    protected String jobDefinitionId;
    protected String[] activityIdIn;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String jobType;
    protected String jobConfiguration;
    protected Boolean active;
    protected Boolean suspended;

    public JobDefinitionQueryDto() {
    }

    public JobDefinitionQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="jobDefinitionId")
    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    @CamundaQueryParam(value="activityIdIn", converter=StringArrayConverter.class)
    public void setActivityIdIn(String[] activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="jobType")
    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    @CamundaQueryParam(value="jobConfiguration")
    public void setJobConfiguration(String jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected JobDefinitionQuery createNewQuery(ProcessEngine engine) {
        return engine.getManagementService().createJobDefinitionQuery();
    }

    protected void applyFilters(JobDefinitionQuery query) {
        if (this.jobDefinitionId != null) {
            query.jobDefinitionId(this.jobDefinitionId);
        }
        if (this.activityIdIn != null && this.activityIdIn.length > 0) {
            query.activityIdIn(this.activityIdIn);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.jobType != null) {
            query.jobType(this.jobType);
        }
        if (this.jobConfiguration != null) {
            query.jobConfiguration(this.jobConfiguration);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.suspended != null && this.suspended.booleanValue()) {
            query.suspended();
        }
    }

    protected void applySortBy(JobDefinitionQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_JOB_DEFINITION_ID)) {
            query.orderByJobDefinitionId();
        } else if (sortBy.equals(SORT_BY_ACTIVITY_ID)) {
            query.orderByActivityId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_KEY)) {
            query.orderByProcessDefinitionKey();
        } else if (sortBy.equals(SORT_BY_JOB_TYPE)) {
            query.orderByJobType();
        } else if (sortBy.equals(SORT_BY_JOB_CONFIGURATION)) {
            query.orderByJobConfiguration();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_CONFIGURATION);
    }
}

