/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.codehaus.jackson.map.ObjectMapper;

public class DeploymentQueryDto
extends AbstractQueryDto<DeploymentQuery> {
    private static final String SORT_BY_ID_VALUE = "id";
    private static final String SORT_BY_NAME_VALUE = "name";
    private static final String SORT_BY_DEPLOYMENT_TIME_VALUE = "deploymentTime";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    private String id;
    private String name;
    private String nameLike;
    private Date before;
    private Date after;

    public DeploymentQueryDto() {
    }

    public DeploymentQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @CamundaQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @CamundaQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @CamundaQueryParam(value="before", converter=DateConverter.class)
    public void setDeploymentBefore(Date deploymentBefore) {
        this.before = deploymentBefore;
    }

    @CamundaQueryParam(value="after", converter=DateConverter.class)
    public void setDeploymentAfter(Date deploymentAfter) {
        this.after = deploymentAfter;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected DeploymentQuery createNewQuery(ProcessEngine engine) {
        return engine.getRepositoryService().createDeploymentQuery();
    }

    protected void applyFilters(DeploymentQuery query) {
        if (this.id != null) {
            query.deploymentId(this.id);
        }
        if (this.name != null) {
            query.deploymentName(this.name);
        }
        if (this.nameLike != null) {
            query.deploymentNameLike(this.nameLike);
        }
        if (this.before != null) {
            query.deploymentBefore(this.before);
        }
        if (this.after != null) {
            query.deploymentAfter(this.after);
        }
    }

    protected void applySortBy(DeploymentQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_ID_VALUE)) {
            query.orderByDeploymentId();
        } else if (sortBy.equals(SORT_BY_NAME_VALUE)) {
            query.orderByDeploymentName();
        } else if (sortBy.equals(SORT_BY_DEPLOYMENT_TIME_VALUE)) {
            query.orderByDeploymenTime();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEPLOYMENT_TIME_VALUE);
    }
}

