/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.hal.caseDefinition;

import javax.ws.rs.core.UriBuilder;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.rest.CaseDefinitionRestService;
import org.camunda.bpm.engine.rest.DeploymentRestService;
import org.camunda.bpm.engine.rest.hal.HalIdResource;
import org.camunda.bpm.engine.rest.hal.HalRelation;
import org.camunda.bpm.engine.rest.hal.HalResource;
import org.camunda.bpm.engine.rest.sub.repository.DeploymentResourcesResource;
import org.camunda.bpm.engine.rest.util.ApplicationContextPathUtil;

public class HalCaseDefinition
extends HalResource<HalCaseDefinition>
implements HalIdResource {
    public static final HalRelation REL_SELF = HalRelation.build((String)"self", CaseDefinitionRestService.class, (UriBuilder)UriBuilder.fromPath((String)"/case-definition").path("{id}"));
    public static final HalRelation REL_DEPLOYMENT = HalRelation.build((String)"deployment", DeploymentRestService.class, (UriBuilder)UriBuilder.fromPath((String)"/deployment").path("{id}"));
    public static final HalRelation REL_DEPLOYMENT_RESOURCE = HalRelation.build((String)"resource", DeploymentResourcesResource.class, (UriBuilder)UriBuilder.fromPath((String)"/deployment").path("{deploymentId}").path("resources").path("{resourceId}"));
    protected String id;
    protected String key;
    protected String category;
    protected String name;
    protected int version;
    protected String resource;
    protected String deploymentId;
    protected String contextPath;

    public static HalCaseDefinition fromCaseDefinition(CaseDefinition caseDefinition, ProcessEngine processEngine) {
        HalCaseDefinition halCaseDefinition = new HalCaseDefinition();
        halCaseDefinition.id = caseDefinition.getId();
        halCaseDefinition.key = caseDefinition.getKey();
        halCaseDefinition.category = caseDefinition.getCategory();
        halCaseDefinition.name = caseDefinition.getName();
        halCaseDefinition.version = caseDefinition.getVersion();
        halCaseDefinition.resource = caseDefinition.getResourceName();
        halCaseDefinition.deploymentId = caseDefinition.getDeploymentId();
        halCaseDefinition.contextPath = ApplicationContextPathUtil.getApplicationPathForDeployment((ProcessEngine)processEngine, (String)caseDefinition.getDeploymentId());
        halCaseDefinition.linker.createLink(REL_SELF, new String[]{caseDefinition.getId()});
        halCaseDefinition.linker.createLink(REL_DEPLOYMENT, new String[]{caseDefinition.getDeploymentId()});
        halCaseDefinition.linker.createLink(REL_DEPLOYMENT_RESOURCE, new String[]{caseDefinition.getDeploymentId(), caseDefinition.getResourceName()});
        return halCaseDefinition;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public String getResource() {
        return this.resource;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getContextPath() {
        return this.contextPath;
    }
}

