/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.CaseExecutionRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.runtime.CaseExecutionDto;
import org.camunda.bpm.engine.rest.dto.runtime.CaseExecutionQueryDto;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.runtime.CaseExecutionResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.CaseExecutionResourceImpl;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.codehaus.jackson.map.ObjectMapper;

public class CaseExecutionRestServiceImpl
extends AbstractRestProcessEngineAware
implements CaseExecutionRestService {
    public CaseExecutionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    public CaseExecutionResource getCaseExecution(String caseExecutionId) {
        return new CaseExecutionResourceImpl(this.getProcessEngine(), caseExecutionId, this.getObjectMapper());
    }

    public List<CaseExecutionDto> getCaseExecutions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CaseExecutionQueryDto queryDto = new CaseExecutionQueryDto(this.getObjectMapper(), uriInfo.getQueryParameters());
        return this.queryCaseExecutions(queryDto, firstResult, maxResults);
    }

    public List<CaseExecutionDto> queryCaseExecutions(CaseExecutionQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        CaseExecutionQuery query = (CaseExecutionQuery)queryDto.toQuery(engine);
        List matchingExecutions = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<CaseExecutionDto> executionResults = new ArrayList<CaseExecutionDto>();
        for (CaseExecution execution : matchingExecutions) {
            CaseExecutionDto resultExecution = CaseExecutionDto.fromCaseExecution((CaseExecution)execution);
            executionResults.add(resultExecution);
        }
        return executionResults;
    }

    private List<CaseExecution> executePaginatedQuery(CaseExecutionQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    public CountResultDto getCaseExecutionsCount(UriInfo uriInfo) {
        CaseExecutionQueryDto queryDto = new CaseExecutionQueryDto(this.getObjectMapper(), uriInfo.getQueryParameters());
        return this.queryCaseExecutionsCount(queryDto);
    }

    public CountResultDto queryCaseExecutionsCount(CaseExecutionQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        CaseExecutionQuery query = (CaseExecutionQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

