/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricProcessInstanceRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricProcessInstanceResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricProcessInstanceResourceImpl;
import org.codehaus.jackson.map.ObjectMapper;

public class HistoricProcessInstanceRestServiceImpl
implements HistoricProcessInstanceRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricProcessInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    public HistoricProcessInstanceResource getHistoricProcessInstance(String processInstanceId) {
        return new HistoricProcessInstanceResourceImpl(this.processEngine, processInstanceId);
    }

    public List<HistoricProcessInstanceDto> getHistoricProcessInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricProcessInstanceQueryDto queryHistoriProcessInstanceDto = new HistoricProcessInstanceQueryDto(this.objectMapper, uriInfo.getQueryParameters());
        return this.queryHistoricProcessInstances(queryHistoriProcessInstanceDto, firstResult, maxResults);
    }

    public List<HistoricProcessInstanceDto> queryHistoricProcessInstances(HistoricProcessInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricProcessInstanceQuery query = (HistoricProcessInstanceQuery)queryDto.toQuery(this.processEngine);
        List matchingHistoricProcessInstances = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<HistoricProcessInstanceDto> historicProcessInstanceDtoResults = new ArrayList<HistoricProcessInstanceDto>();
        for (HistoricProcessInstance historicProcessInstance : matchingHistoricProcessInstances) {
            HistoricProcessInstanceDto resultHistoricProcessInstanceDto = HistoricProcessInstanceDto.fromHistoricProcessInstance((HistoricProcessInstance)historicProcessInstance);
            historicProcessInstanceDtoResults.add(resultHistoricProcessInstanceDto);
        }
        return historicProcessInstanceDtoResults;
    }

    private List<HistoricProcessInstance> executePaginatedQuery(HistoricProcessInstanceQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    public CountResultDto getHistoricProcessInstancesCount(UriInfo uriInfo) {
        HistoricProcessInstanceQueryDto queryDto = new HistoricProcessInstanceQueryDto(this.objectMapper, uriInfo.getQueryParameters());
        return this.queryHistoricProcessInstancesCount(queryDto);
    }

    public CountResultDto queryHistoricProcessInstancesCount(HistoricProcessInstanceQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricProcessInstanceQuery query = (HistoricProcessInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

