/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.RequestContext;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.mapper.MultipartFormData;
import org.camunda.bpm.engine.rest.mapper.MultipartPayloadProvider;

@Provider
@Consumes(value={"multipart/form-data"})
public final class MultipartPayloadProvider
implements MessageBodyReader<MultipartFormData> {
    public static final String TYPE_NAME = "multipart";
    public static final String SUB_TYPE_NAME = "form-data";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return TYPE_NAME.equals(mediaType.getType().toLowerCase()) && SUB_TYPE_NAME.equals(mediaType.getSubtype().toLowerCase());
    }

    public MultipartFormData readFrom(Class<MultipartFormData> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MultipartFormData multipartFormData = this.createMultipartFormDataInstance();
        FileUpload fileUpload = this.createFileUploadInstance();
        String contentType = (String)httpHeaders.getFirst((Object)"content-type");
        RestMultipartRequestContext requestContext = this.createRequestContext(entityStream, contentType);
        this.parseRequest(multipartFormData, fileUpload, requestContext);
        return multipartFormData;
    }

    protected FileUpload createFileUploadInstance() {
        return new FileUpload();
    }

    protected MultipartFormData createMultipartFormDataInstance() {
        return new MultipartFormData();
    }

    protected void parseRequest(MultipartFormData multipartFormData, FileUpload fileUpload, RestMultipartRequestContext requestContext) {
        try {
            FileItemIterator itemIterator = fileUpload.getItemIterator((RequestContext)requestContext);
            while (itemIterator.hasNext()) {
                FileItemStream stream = itemIterator.next();
                multipartFormData.addPart(new MultipartFormData.FormPart(stream));
            }
        }
        catch (Exception e) {
            throw new RestException(Response.Status.BAD_REQUEST, e, "multipart/form-data cannot be processed");
        }
    }

    protected RestMultipartRequestContext createRequestContext(InputStream entityStream, String contentType) {
        return new RestMultipartRequestContext(entityStream, contentType);
    }
}

