/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.history.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.rest.dto.history.HistoricDetailDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.history.HistoricDetailResource;
import org.camunda.bpm.engine.variable.type.ValueType;

public class HistoricDetailResourceImpl
implements HistoricDetailResource {
    protected String detailId;
    protected ProcessEngine engine;

    public HistoricDetailResourceImpl(String detailId, ProcessEngine engine) {
        this.detailId = detailId;
        this.engine = engine;
    }

    public HistoricDetailDto getDetail(boolean deserializeObjectValue) {
        HistoricDetail detail;
        HistoricDetailQuery query = this.baseQuery().disableBinaryFetching();
        if (!deserializeObjectValue) {
            query.disableCustomObjectDeserialization();
        }
        if ((detail = (HistoricDetail)query.singleResult()) != null) {
            return HistoricDetailDto.fromHistoricDetail((HistoricDetail)detail);
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic detail with Id '" + this.detailId + "' does not exist.");
    }

    public InputStream getBinaryVariable() {
        HistoricDetail historicDetail = (HistoricDetail)this.baseQuery().disableCustomObjectDeserialization().singleResult();
        if (historicDetail != null) {
            if (!(historicDetail instanceof HistoricVariableUpdate)) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Historic detail with Id '" + this.detailId + "' is not a variable update.");
            }
            HistoricVariableUpdate update = (HistoricVariableUpdate)historicDetail;
            if (ValueType.BYTES.getName().equals(update.getTypeName())) {
                byte[] valueBytes = (byte[])update.getValue();
                if (valueBytes == null) {
                    valueBytes = new byte[]{};
                }
                return new ByteArrayInputStream(valueBytes);
            }
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, String.format("Value of variable %s is not a binary value.", this.detailId));
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic detail instance with Id '" + this.detailId + "' does not exist.");
    }

    protected HistoricDetailQuery baseQuery() {
        return this.engine.getHistoryService().createHistoricDetailQuery().detailId(this.detailId);
    }
}

