/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.history.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.rest.dto.history.HistoricVariableInstanceDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.history.HistoricVariableInstanceResource;
import org.camunda.bpm.engine.variable.type.ValueType;

public class HistoricVariableInstanceResourceImpl
implements HistoricVariableInstanceResource {
    protected String variableId;
    protected ProcessEngine engine;

    public HistoricVariableInstanceResourceImpl(String variableId, ProcessEngine engine) {
        this.variableId = variableId;
        this.engine = engine;
    }

    public HistoricVariableInstanceDto getVariable(boolean deserializeObjectValue) {
        HistoricVariableInstance variableInstance;
        HistoricVariableInstanceQuery query = this.baseQuery().disableBinaryFetching();
        if (!deserializeObjectValue) {
            query.disableCustomObjectDeserialization();
        }
        if ((variableInstance = (HistoricVariableInstance)query.singleResult()) != null) {
            return HistoricVariableInstanceDto.fromHistoricVariableInstance((HistoricVariableInstance)variableInstance);
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Variable instance with Id '" + this.variableId + "' does not exist.");
    }

    public InputStream getBinaryVariable() {
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.baseQuery().disableCustomObjectDeserialization().singleResult();
        if (variableInstance != null) {
            if (variableInstance.getTypeName().equals(ValueType.BYTES.getName())) {
                byte[] valueBytes = (byte[])variableInstance.getValue();
                if (valueBytes == null) {
                    valueBytes = new byte[]{};
                }
                return new ByteArrayInputStream(valueBytes);
            }
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, String.format("Value of variable %s is not a binary value.", this.variableId));
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic variable instance with Id '" + this.variableId + "' does not exist.");
    }

    protected HistoricVariableInstanceQuery baseQuery() {
        return this.engine.getHistoryService().createHistoricVariableInstanceQuery().variableId(this.variableId);
    }
}

