/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.repository.impl;

import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.rest.dto.repository.DeploymentDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.repository.DeploymentResource;
import org.camunda.bpm.engine.rest.sub.repository.DeploymentResourcesResource;
import org.camunda.bpm.engine.rest.sub.repository.impl.DeploymentResourcesResourceImpl;

public class DeploymentResourceImpl
implements DeploymentResource {
    private ProcessEngine engine;
    private String deploymentId;

    public DeploymentResourceImpl(ProcessEngine engine, String deploymentId) {
        this.engine = engine;
        this.deploymentId = deploymentId;
    }

    public DeploymentDto getDeployment() {
        RepositoryService repositoryService = this.engine.getRepositoryService();
        Deployment deployment = (Deployment)repositoryService.createDeploymentQuery().deploymentId(this.deploymentId).singleResult();
        if (deployment == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Deployment with id '" + this.deploymentId + "' does not exist");
        }
        return DeploymentDto.fromDeployment((Deployment)deployment);
    }

    public DeploymentResourcesResource getDeploymentResources() {
        return new DeploymentResourcesResourceImpl(this.engine, this.deploymentId);
    }

    public void deleteDeployment(String deploymentId, UriInfo uriInfo) {
        RepositoryService repositoryService = this.engine.getRepositoryService();
        Deployment deployment = (Deployment)repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Deployment with id '" + deploymentId + "' do not exist");
        }
        boolean cascade = false;
        if (uriInfo.getQueryParameters().containsKey((Object)"cascade") && ((List)uriInfo.getQueryParameters().get((Object)"cascade")).size() > 0 && "true".equals(((List)uriInfo.getQueryParameters().get((Object)"cascade")).get(0))) {
            cascade = true;
        }
        repositoryService.deleteDeployment(deploymentId, cascade);
    }
}

