/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.PrimitiveValueType;
import org.camunda.bpm.engine.variable.type.SerializableValueType;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.type.ValueTypeResolver;
import org.camunda.bpm.engine.variable.value.SerializableValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class VariableValueDto {
    protected String type;
    protected Object value;
    protected Map<String, Object> valueInfo;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Map<String, Object> getValueInfo() {
        return this.valueInfo;
    }

    public void setValueInfo(Map<String, Object> valueInfo) {
        this.valueInfo = valueInfo;
    }

    public TypedValue toTypedValue(ProcessEngine processEngine, ObjectMapper objectMapper) {
        ValueTypeResolver valueTypeResolver = processEngine.getProcessEngineConfiguration().getValueTypeResolver();
        if (this.type == null) {
            return Variables.untypedValue((Object)this.value);
        }
        ValueType valueType = valueTypeResolver.typeForName(VariableValueDto.fromRestApiTypeName((String)this.type));
        if (valueType == null) {
            throw new RestException(Response.Status.BAD_REQUEST, String.format("Unsupported value type '%s'", this.type));
        }
        if (valueType instanceof PrimitiveValueType) {
            PrimitiveValueType primitiveValueType = (PrimitiveValueType)valueType;
            Class javaType = primitiveValueType.getJavaType();
            Object mappedValue = null;
            try {
                if (this.value != null) {
                    mappedValue = javaType.isAssignableFrom(this.value.getClass()) ? this.value : objectMapper.readValue("\"" + this.value + "\"", javaType);
                }
                return valueType.createValue(mappedValue, this.valueInfo);
            }
            catch (Exception e) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, e, String.format("Cannot convert value '%s' of type '%s' to java type %s", this.value, this.type, javaType.getName()));
            }
        }
        if (valueType instanceof SerializableValueType) {
            if (this.value != null && !(this.value instanceof String)) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Must provide 'null' or String value for value of SerializableValue type '" + this.type + "'.");
            }
            return ((SerializableValueType)valueType).createValueFromSerialized((String)this.value, this.valueInfo);
        }
        return valueType.createValue(this.value, this.valueInfo);
    }

    public static VariableMap toMap(Map<String, VariableValueDto> variables, ProcessEngine processEngine, ObjectMapper objectMapper) {
        if (variables == null) {
            return null;
        }
        VariableMap result = Variables.createVariables();
        for (Map.Entry<String, VariableValueDto> variableEntry : variables.entrySet()) {
            result.put((Object)variableEntry.getKey(), (Object)variableEntry.getValue().toTypedValue(processEngine, objectMapper));
        }
        return result;
    }

    public static VariableValueDto fromTypedValue(TypedValue typedValue) {
        VariableValueDto dto = new VariableValueDto();
        VariableValueDto.fromTypedValue((VariableValueDto)dto, (TypedValue)typedValue);
        return dto;
    }

    public static void fromTypedValue(VariableValueDto dto, TypedValue typedValue) {
        String typeName = typedValue.getType().getName();
        dto.setType(VariableValueDto.toRestApiTypeName((String)typeName));
        dto.setValueInfo(typedValue.getType().getValueInfo(typedValue));
        if (typedValue instanceof SerializableValue) {
            SerializableValue serializableValue = (SerializableValue)typedValue;
            if (serializableValue.isDeserialized()) {
                dto.setValue(serializableValue.getValue());
            } else {
                dto.setValue((Object)serializableValue.getValueSerialized());
            }
        } else {
            dto.setValue(typedValue.getValue());
        }
    }

    public static String toRestApiTypeName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String fromRestApiTypeName(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static Map<String, VariableValueDto> fromVariableMap(VariableMap variables) {
        HashMap<String, VariableValueDto> result = new HashMap<String, VariableValueDto>();
        for (String name : variables.keySet()) {
            result.put(name, VariableValueDto.fromTypedValue((TypedValue)variables.getValueTyped(name)));
        }
        return result;
    }
}

