/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.converter;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.rest.dto.converter.StringToTypeConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class JacksonAwareStringToTypeConverter<T>
implements StringToTypeConverter<T> {
    protected ObjectMapper objectMapper;

    public abstract T convertQueryParameterToType(String var1);

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected T mapToType(String value, Class<T> typeClass) {
        try {
            return (T)this.objectMapper.readValue(value, typeClass);
        }
        catch (JsonParseException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), String.format("Cannot convert value %s to java type %s", value, typeClass.getName()));
        }
        catch (JsonMappingException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), String.format("Cannot convert value %s to java type %s", value, typeClass.getName()));
        }
        catch (IOException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)e, String.format("Cannot convert value %s to java type %s", value, typeClass.getName()));
        }
    }
}

