/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.task.TaskQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class FilterDto {
    protected String id;
    protected String resourceType;
    protected String name;
    protected String owner;
    protected JsonNode query;
    protected AbstractQueryDto<?> resolvedQuery;
    protected Map<String, Object> properties;
    protected Long itemCount;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public JsonNode getQuery() {
        return this.query;
    }

    public AbstractQueryDto<?> resolveQuery(ObjectMapper objectMapper) {
        if (this.resolvedQuery == null) {
            try {
                this.resolvedQuery = (AbstractQueryDto)objectMapper.readValue(this.query, TaskQueryDto.class);
            }
            catch (Exception e) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, e, "Unable to convert query");
            }
        }
        return this.resolvedQuery;
    }

    public void setQuery(JsonNode query) {
        this.query = query;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public Long getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(Long itemCount) {
        this.itemCount = itemCount;
    }

    public static FilterDto fromFilter(Filter filter, ObjectMapper objectMapper) {
        FilterDto dto = new FilterDto();
        dto.id = filter.getId();
        dto.resourceType = filter.getResourceType();
        dto.name = filter.getName();
        dto.owner = filter.getOwner();
        if ("Task".equals(filter.getResourceType())) {
            dto.query = objectMapper.valueToTree((Object)TaskQueryDto.fromQuery((Query)filter.getQuery()));
        }
        dto.properties = filter.getProperties();
        return dto;
    }

    public void updateFilter(Filter filter, ProcessEngine engine, ObjectMapper objectMapper) {
        if (this.getResourceType() != null && !this.getResourceType().equals(filter.getResourceType())) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Unable to update filter from resource type '" + filter.getResourceType() + "' to '" + this.getResourceType() + "'");
        }
        filter.setName(this.getName());
        filter.setOwner(this.getOwner());
        Query query = this.resolveQuery(objectMapper).toQuery(engine);
        filter.setQuery(query);
        filter.setProperties(this.getProperties());
    }
}

