/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.history.impl;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.history.HistoricProcessInstanceResource;

public class HistoricProcessInstanceResourceImpl
implements HistoricProcessInstanceResource {
    private ProcessEngine engine;
    private String processInstanceId;

    public HistoricProcessInstanceResourceImpl(ProcessEngine engine, String processInstanceId) {
        this.engine = engine;
        this.processInstanceId = processInstanceId;
    }

    public HistoricProcessInstanceDto getHistoricProcessInstance() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricProcessInstance instance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(this.processInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic process instance with id " + this.processInstanceId + " does not exist");
        }
        return HistoricProcessInstanceDto.fromHistoricProcessInstance((HistoricProcessInstance)instance);
    }
}

