/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.management;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.rest.dto.management.JobDefinitionDto;
import org.camunda.bpm.engine.rest.dto.management.JobDefinitionSuspensionStateDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobRetriesDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.management.JobDefinitionResource;

public class JobDefinitionResourceImpl
implements JobDefinitionResource {
    protected ProcessEngine engine;
    protected String jobDefinitionId;

    public JobDefinitionResourceImpl(ProcessEngine engine, String jobDefinitionId) {
        this.engine = engine;
        this.jobDefinitionId = jobDefinitionId;
    }

    public JobDefinitionDto getJobDefinition() {
        ManagementService managementService = this.engine.getManagementService();
        JobDefinition jobDefinition = (JobDefinition)managementService.createJobDefinitionQuery().jobDefinitionId(this.jobDefinitionId).singleResult();
        if (jobDefinition == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Job Definition with id " + this.jobDefinitionId + " does not exist");
        }
        return JobDefinitionDto.fromJobDefinition((JobDefinition)jobDefinition);
    }

    public void updateSuspensionState(JobDefinitionSuspensionStateDto dto) {
        try {
            dto.setJobDefinitionId(this.jobDefinitionId);
            dto.updateSuspensionState(this.engine);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("The suspension state of Job Definition with id %s could not be updated due to: %s", this.jobDefinitionId, e.getMessage());
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)e, message);
        }
    }

    public void setJobRetries(JobRetriesDto dto) {
        try {
            ManagementService managementService = this.engine.getManagementService();
            managementService.setJobRetriesByJobDefinitionId(this.jobDefinitionId, dto.getRetries());
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }
}

