/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.rest.sub.impl.AbstractVariablesResource;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.codehaus.jackson.map.ObjectMapper;

public class ExecutionVariablesResource
extends AbstractVariablesResource {
    private String resourceTypeName;

    public ExecutionVariablesResource(ProcessEngine engine, String resourceId, boolean isProcessInstance, ObjectMapper objectMapper) {
        super(engine, resourceId, objectMapper);
        this.resourceTypeName = isProcessInstance ? "process instance" : "execution";
    }

    protected String getResourceTypeName() {
        return this.resourceTypeName;
    }

    protected void updateVariableEntities(VariableMap modifications, List<String> deletions) {
        RuntimeServiceImpl runtimeService = (RuntimeServiceImpl)this.engine.getRuntimeService();
        runtimeService.updateVariables(this.resourceId, (Map)modifications, deletions);
    }

    protected void removeVariableEntity(String variableKey) {
        this.engine.getRuntimeService().removeVariable(this.resourceId, variableKey);
    }

    protected VariableMap getVariableEntities(boolean deserializeValues) {
        return this.engine.getRuntimeService().getVariablesTyped(this.resourceId, deserializeValues);
    }

    protected TypedValue getVariableEntity(String variableKey, boolean deserializeValue) {
        return this.engine.getRuntimeService().getVariableTyped(this.resourceId, variableKey, deserializeValue);
    }

    protected void setVariableEntity(String variableKey, TypedValue variableValue) {
        this.engine.getRuntimeService().setVariable(this.resourceId, variableKey, (Object)variableValue);
    }
}

