/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.runtime.VariableInstanceDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.runtime.VariableInstanceResource;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.variable.type.ValueType;

public class VariableInstanceResourceImpl
implements VariableInstanceResource {
    protected String variableId;
    protected ProcessEngine engine;

    public VariableInstanceResourceImpl(String variableId, ProcessEngine engine) {
        this.variableId = variableId;
        this.engine = engine;
    }

    public VariableInstanceDto getVariable(boolean deserializeObjectValue) {
        VariableInstance variableInstance;
        VariableInstanceQuery baseQuery = this.baseQuery();
        baseQuery.disableBinaryFetching();
        if (!deserializeObjectValue) {
            baseQuery.disableCustomObjectDeserialization();
        }
        if ((variableInstance = (VariableInstance)baseQuery.singleResult()) != null) {
            return VariableInstanceDto.fromVariableInstance((VariableInstance)variableInstance);
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Variable instance with Id '" + this.variableId + "' does not exist.");
    }

    public InputStream getBinaryVariable() {
        VariableInstance variableInstance = (VariableInstance)this.baseQuery().disableCustomObjectDeserialization().singleResult();
        if (variableInstance != null) {
            if (variableInstance.getTypeName().equals(ValueType.BYTES.getName())) {
                byte[] valueBytes = (byte[])variableInstance.getValue();
                if (valueBytes == null) {
                    valueBytes = new byte[]{};
                }
                return new ByteArrayInputStream(valueBytes);
            }
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, String.format("Value of variable %s is not a binary value.", this.variableId));
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Variable instance with Id '" + this.variableId + "' does not exist.");
    }

    protected VariableInstanceQuery baseQuery() {
        return this.engine.getRuntimeService().createVariableInstanceQuery().variableId(this.variableId);
    }
}

