/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.SortingDto;
import org.camunda.bpm.engine.rest.dto.converter.JacksonAwareStringToTypeConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;

public abstract class AbstractQueryDto<T extends Query<?, ?>> {
    public static final String SORT_ORDER_ASC_VALUE = "asc";
    public static final String SORT_ORDER_DESC_VALUE = "desc";
    public static final List<String> VALID_SORT_ORDER_VALUES = new ArrayList();
    protected ObjectMapper objectMapper;
    protected String sortBy;
    protected String sortOrder;
    protected List<SortingDto> sortings;
    protected Map<String, String> expressions = new HashMap();

    public AbstractQueryDto() {
    }

    public AbstractQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        this.objectMapper = objectMapper;
        for (Map.Entry param : queryParameters.entrySet()) {
            String key = (String)param.getKey();
            String value = (String)((List)param.getValue()).iterator().next();
            this.setValueBasedOnAnnotation(key, value);
        }
    }

    @JsonIgnore
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @CamundaQueryParam(value="sortBy")
    public void setSortBy(String sortBy) {
        if (!this.isValidSortByValue(sortBy)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "sortBy parameter has invalid value: " + sortBy);
        }
        this.sortBy = sortBy;
    }

    @CamundaQueryParam(value="sortOrder")
    public void setSortOrder(String sortOrder) {
        if (!VALID_SORT_ORDER_VALUES.contains(sortOrder)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "sortOrder parameter has invalid value: " + sortOrder);
        }
        this.sortOrder = sortOrder;
    }

    public void setSorting(List<SortingDto> sorting) {
        this.sortings = sorting;
    }

    public List<SortingDto> getSorting() {
        return this.sortings;
    }

    protected abstract boolean isValidSortByValue(String var1);

    protected boolean sortOptionsValid() {
        return this.sortBy != null && this.sortOrder != null || this.sortBy == null && this.sortOrder == null;
    }

    protected void setValueBasedOnAnnotation(String key, String value) {
        List matchingMethods = this.findMatchingAnnotatedMethods(key);
        for (Method method : matchingMethods) {
            Class converterClass = this.findAnnotatedTypeConverter(method);
            if (converterClass == null) continue;
            JacksonAwareStringToTypeConverter converter = null;
            try {
                converter = (JacksonAwareStringToTypeConverter)converterClass.newInstance();
                converter.setObjectMapper(this.objectMapper);
                Object convertedValue = converter.convertQueryParameterToType(value);
                method.invoke((Object)this, convertedValue);
            }
            catch (InstantiationException e) {
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)e, "Server error.");
            }
            catch (IllegalAccessException e) {
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)e, "Server error.");
            }
            catch (InvocationTargetException e) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)e, "Cannot set query parameter '" + key + "' to value '" + value + "'");
            }
            catch (RestException e) {
                throw new InvalidRequestException(e.getStatus(), (Exception)((Object)e), "Cannot set query parameter '" + key + "' to value '" + value + "': " + e.getMessage());
            }
        }
    }

    private List<Method> findMatchingAnnotatedMethods(String parameterName) {
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Annotation[] methodAnnotations = method.getAnnotations();
            for (int j = 0; j < methodAnnotations.length; ++j) {
                CamundaQueryParam parameterAnnotation;
                Annotation annotation = methodAnnotations[j];
                if (!(annotation instanceof CamundaQueryParam) || !(parameterAnnotation = (CamundaQueryParam)annotation).value().equals(parameterName)) continue;
                result.add(method);
            }
        }
        return result;
    }

    private Class<? extends JacksonAwareStringToTypeConverter<?>> findAnnotatedTypeConverter(Method method) {
        Annotation[] methodAnnotations = method.getAnnotations();
        for (int j = 0; j < methodAnnotations.length; ++j) {
            Annotation annotation = methodAnnotations[j];
            if (!(annotation instanceof CamundaQueryParam)) continue;
            CamundaQueryParam parameterAnnotation = (CamundaQueryParam)annotation;
            return parameterAnnotation.converter();
        }
        return null;
    }

    public T toQuery(ProcessEngine engine) {
        Query query = this.createNewQuery(engine);
        this.applyFilters(query);
        if (!this.sortOptionsValid()) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only a single sorting parameter specified. sortBy and sortOrder required");
        }
        this.applySortingOptions(query, engine);
        return (T)query;
    }

    protected abstract T createNewQuery(ProcessEngine var1);

    protected abstract void applyFilters(T var1);

    protected void applySortingOptions(T query, ProcessEngine engine) {
        if (this.sortBy != null) {
            this.applySortBy(query, this.sortBy, null, engine);
        }
        if (this.sortOrder != null) {
            this.applySortOrder(query, this.sortOrder);
        }
        if (this.sortings != null) {
            for (SortingDto sorting : this.sortings) {
                String sortingOrder = sorting.getSortOrder();
                String sortingBy = sorting.getSortBy();
                if (sortingBy != null) {
                    this.applySortBy(query, sortingBy, sorting.getParameters(), engine);
                }
                if (sortingOrder == null) continue;
                this.applySortOrder(query, sortingOrder);
            }
        }
    }

    protected abstract void applySortBy(T var1, String var2, Map<String, Object> var3, ProcessEngine var4);

    protected void applySortOrder(T query, String sortOrder) {
        if (sortOrder != null) {
            if (sortOrder.equals(SORT_ORDER_ASC_VALUE)) {
                query.asc();
            } else if (sortOrder.equals(SORT_ORDER_DESC_VALUE)) {
                query.desc();
            }
        }
    }

    public static String sortOrderValueForDirection(Direction direction) {
        if (Direction.ASCENDING.equals(direction)) {
            return SORT_ORDER_ASC_VALUE;
        }
        if (Direction.DESCENDING.equals(direction)) {
            return SORT_ORDER_DESC_VALUE;
        }
        throw new RestException("Unknown query sorting direction " + direction);
    }

    static {
        VALID_SORT_ORDER_VALUES.add(SORT_ORDER_ASC_VALUE);
        VALID_SORT_ORDER_VALUES.add(SORT_ORDER_DESC_VALUE);
    }
}

