/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.converter;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.JacksonAwareStringToTypeConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class VariableListConverter
extends JacksonAwareStringToTypeConverter<List<VariableQueryParameterDto>> {
    private static final String EXPRESSION_DELIMITER = ",";
    private static final String ATTRIBUTE_DELIMITER = "_";

    public List<VariableQueryParameterDto> convertQueryParameterToType(String value) {
        String[] expressions = value.split(EXPRESSION_DELIMITER);
        ArrayList<VariableQueryParameterDto> queryVariables = new ArrayList<VariableQueryParameterDto>();
        for (String expression : expressions) {
            String[] valueTriple = expression.split(ATTRIBUTE_DELIMITER);
            if (valueTriple.length != 3) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "variable query parameter has to have format KEY_OPERATOR_VALUE.");
            }
            VariableQueryParameterDto queryVariable = new VariableQueryParameterDto();
            queryVariable.setName(valueTriple[0]);
            queryVariable.setOperator(valueTriple[1]);
            queryVariable.setValue((Object)valueTriple[2]);
            queryVariables.add(queryVariable);
        }
        return queryVariables;
    }
}

