/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;

public class HistoricCaseActivityInstanceQueryDto
extends AbstractQueryDto<HistoricCaseActivityInstanceQuery> {
    protected static final String SORT_BY_HISTORIC_ACTIVITY_INSTANCE_ID_VALUE = "caseActivityInstanceId";
    protected static final String SORT_BY_CASE_INSTANCE_ID_VALUE = "caseInstanceId";
    protected static final String SORT_BY_CASE_EXECUTION_ID_VALUE = "caseExecutionId";
    protected static final String SORT_BY_CASE_ACTIVITY_ID_VALUE = "caseActivityId";
    protected static final String SORT_BY_CASE_ACTIVITY_NAME_VALUE = "caseActivityName";
    protected static final String SORT_BY_CASE_ACTIVITY_TYPE_VALUE = "caseActivityType";
    protected static final String SORT_BY_HISTORIC_CASE_ACTIVITY_INSTANCE_CREATE_TIME_VALUE = "createTime";
    protected static final String SORT_BY_HISTORIC_CASE_ACTIVITY_INSTANCE_END_TIME_VALUE = "endTime";
    protected static final String SORT_BY_HISTORIC_CASE_ACTIVITY_INSTANCE_DURATION_VALUE = "duration";
    protected static final String SORT_BY_CASE_DEFINITION_ID_VALUE = "caseDefinitionId";
    protected static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    protected String caseActivityInstanceId;
    protected String caseInstanceId;
    protected String caseDefinitionId;
    protected String caseExecutionId;
    protected String caseActivityId;
    protected String caseActivityName;
    protected String caseActivityType;
    protected Date createdBefore;
    protected Date createdAfter;
    protected Date endedBefore;
    protected Date endedAfter;
    protected Boolean required;
    protected Boolean finished;
    protected Boolean unfinished;
    protected Boolean available;
    protected Boolean enabled;
    protected Boolean disabled;
    protected Boolean active;
    protected Boolean completed;
    protected Boolean terminated;

    public HistoricCaseActivityInstanceQueryDto() {
    }

    public HistoricCaseActivityInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="caseActivityInstanceId")
    public void setCaseActivityInstanceId(String caseActivityInstanceId) {
        this.caseActivityInstanceId = caseActivityInstanceId;
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @CamundaQueryParam(value="caseExecutionId")
    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @CamundaQueryParam(value="caseActivityId")
    public void setCaseActivityId(String caseActivityId) {
        this.caseActivityId = caseActivityId;
    }

    @CamundaQueryParam(value="caseActivityName")
    public void setCaseActivityName(String caseActivityName) {
        this.caseActivityName = caseActivityName;
    }

    @CamundaQueryParam(value="caseActivityType")
    public void setCaseActivityType(String caseActivityType) {
        this.caseActivityType = caseActivityType;
    }

    @CamundaQueryParam(value="createdBefore", converter=DateConverter.class)
    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    @CamundaQueryParam(value="createdAfter", converter=DateConverter.class)
    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    @CamundaQueryParam(value="endedBefore", converter=DateConverter.class)
    public void setEndedBefore(Date endedBefore) {
        this.endedBefore = endedBefore;
    }

    @CamundaQueryParam(value="endedAfter", converter=DateConverter.class)
    public void setEndedAfter(Date endedAfter) {
        this.endedAfter = endedAfter;
    }

    @CamundaQueryParam(value="required", converter=BooleanConverter.class)
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @CamundaQueryParam(value="finished", converter=BooleanConverter.class)
    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    @CamundaQueryParam(value="unfinished", converter=BooleanConverter.class)
    public void setUnfinished(Boolean unfinished) {
        this.unfinished = unfinished;
    }

    @CamundaQueryParam(value="available", converter=BooleanConverter.class)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    @CamundaQueryParam(value="enabled", converter=BooleanConverter.class)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @CamundaQueryParam(value="disabled", converter=BooleanConverter.class)
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="completed", converter=BooleanConverter.class)
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    @CamundaQueryParam(value="terminated", converter=BooleanConverter.class)
    public void setTerminated(Boolean terminated) {
        this.terminated = terminated;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected HistoricCaseActivityInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricCaseActivityInstanceQuery();
    }

    protected void applyFilters(HistoricCaseActivityInstanceQuery query) {
        if (this.caseActivityInstanceId != null) {
            query.caseActivityInstanceId(this.caseActivityInstanceId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.caseExecutionId != null) {
            query.caseExecutionId(this.caseExecutionId);
        }
        if (this.caseActivityId != null) {
            query.caseActivityId(this.caseActivityId);
        }
        if (this.caseActivityName != null) {
            query.caseActivityName(this.caseActivityName);
        }
        if (this.caseActivityType != null) {
            query.caseActivityType(this.caseActivityType);
        }
        if (this.createdBefore != null) {
            query.createdBefore(this.createdBefore);
        }
        if (this.createdAfter != null) {
            query.createdAfter(this.createdAfter);
        }
        if (this.endedBefore != null) {
            query.endedBefore(this.endedBefore);
        }
        if (this.endedAfter != null) {
            query.endedAfter(this.endedAfter);
        }
        if (this.required != null && this.required.booleanValue()) {
            query.required();
        }
        if (this.finished != null && this.finished.booleanValue()) {
            query.ended();
        }
        if (this.unfinished != null && this.unfinished.booleanValue()) {
            query.notEnded();
        }
        if (this.available != null && this.available.booleanValue()) {
            query.available();
        }
        if (this.enabled != null && this.enabled.booleanValue()) {
            query.enabled();
        }
        if (this.disabled != null && this.disabled.booleanValue()) {
            query.disabled();
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.completed != null && this.completed.booleanValue()) {
            query.completed();
        }
        if (this.terminated != null && this.terminated.booleanValue()) {
            query.terminated();
        }
    }

    protected void applySortBy(HistoricCaseActivityInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_HISTORIC_ACTIVITY_INSTANCE_ID_VALUE)) {
            query.orderByHistoricCaseActivityInstanceId();
        } else if (sortBy.equals(SORT_BY_CASE_INSTANCE_ID_VALUE)) {
            query.orderByCaseInstanceId();
        } else if (sortBy.equals(SORT_BY_CASE_EXECUTION_ID_VALUE)) {
            query.orderByCaseExecutionId();
        } else if (sortBy.equals(SORT_BY_CASE_ACTIVITY_ID_VALUE)) {
            query.orderByCaseActivityId();
        } else if (sortBy.equals(SORT_BY_CASE_ACTIVITY_NAME_VALUE)) {
            query.orderByCaseActivityName();
        } else if (sortBy.equals(SORT_BY_CASE_ACTIVITY_TYPE_VALUE)) {
            query.orderByCaseActivityType();
        } else if (sortBy.equals(SORT_BY_HISTORIC_CASE_ACTIVITY_INSTANCE_CREATE_TIME_VALUE)) {
            query.orderByHistoricCaseActivityInstanceCreateTime();
        } else if (sortBy.equals(SORT_BY_HISTORIC_CASE_ACTIVITY_INSTANCE_END_TIME_VALUE)) {
            query.orderByHistoricCaseActivityInstanceEndTime();
        } else if (sortBy.equals(SORT_BY_HISTORIC_CASE_ACTIVITY_INSTANCE_DURATION_VALUE)) {
            query.orderByHistoricCaseActivityInstanceDuration();
        } else if (sortBy.equals(SORT_BY_CASE_DEFINITION_ID_VALUE)) {
            query.orderByCaseDefinitionId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_HISTORIC_ACTIVITY_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_ACTIVITY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_ACTIVITY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_ACTIVITY_TYPE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_HISTORIC_CASE_ACTIVITY_INSTANCE_CREATE_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_HISTORIC_CASE_ACTIVITY_INSTANCE_END_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_HISTORIC_CASE_ACTIVITY_INSTANCE_DURATION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_DEFINITION_ID_VALUE);
    }
}

