/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;

public class HistoricDetailQueryDto
extends AbstractQueryDto<HistoricDetailQuery> {
    private static final String SORT_BY_PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String SORT_BY_VARIABLE_NAME = "variableName";
    private static final String SORT_BY_VARIABLE_TYPE = "variableType";
    private static final String SORT_BY_VARIABLE_REVISION = "variableRevision";
    private static final String SORT_BY_FORM_PROPERTY_ID = "formPropertyId";
    private static final String SORT_BY_TIME = "time";
    private static final String SORT_PARTIALLY_BY_OCCURENCE = "occurrence";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    protected String processInstanceId;
    protected String executionId;
    protected String activityInstanceId;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String variableInstanceId;
    protected String taskId;
    protected Boolean formFields;
    protected Boolean variableUpdates;
    protected Boolean excludeTaskDetails;

    public HistoricDetailQueryDto() {
    }

    public HistoricDetailQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="activityInstanceId")
    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="caseExecutionId")
    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @CamundaQueryParam(value="variableInstanceId")
    public void setVariableInstanceId(String variableInstanceId) {
        this.variableInstanceId = variableInstanceId;
    }

    @CamundaQueryParam(value="taskId")
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @CamundaQueryParam(value="formFields", converter=BooleanConverter.class)
    public void setFormFields(Boolean formFields) {
        this.formFields = formFields;
    }

    @CamundaQueryParam(value="variableUpdates", converter=BooleanConverter.class)
    public void setVariableUpdates(Boolean variableUpdates) {
        this.variableUpdates = variableUpdates;
    }

    @CamundaQueryParam(value="excludeTaskDetails", converter=BooleanConverter.class)
    public void setExcludeTaskDetails(Boolean excludeTaskDetails) {
        this.excludeTaskDetails = excludeTaskDetails;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected HistoricDetailQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricDetailQuery();
    }

    protected void applyFilters(HistoricDetailQuery query) {
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.activityInstanceId != null) {
            query.activityInstanceId(this.activityInstanceId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.caseExecutionId != null) {
            query.caseExecutionId(this.caseExecutionId);
        }
        if (this.variableInstanceId != null) {
            query.variableInstanceId(this.variableInstanceId);
        }
        if (this.taskId != null) {
            query.taskId(this.taskId);
        }
        if (this.formFields != null) {
            query.formFields();
        }
        if (this.variableUpdates != null) {
            query.variableUpdates();
        }
        if (this.excludeTaskDetails != null) {
            query.excludeTaskDetails();
        }
    }

    protected void applySortBy(HistoricDetailQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_VARIABLE_NAME)) {
            query.orderByVariableName();
        } else if (sortBy.equals(SORT_BY_VARIABLE_TYPE)) {
            query.orderByVariableType();
        } else if (sortBy.equals(SORT_BY_VARIABLE_REVISION)) {
            query.orderByVariableRevision();
        } else if (sortBy.equals(SORT_BY_FORM_PROPERTY_ID)) {
            query.orderByFormPropertyId();
        } else if (sortBy.equals(SORT_BY_TIME)) {
            query.orderByTime();
        } else if (sortBy.equals(SORT_PARTIALLY_BY_OCCURENCE)) {
            query.orderPartiallyByOccurrence();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_VARIABLE_NAME);
        VALID_SORT_BY_VALUES.add(SORT_BY_VARIABLE_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_VARIABLE_REVISION);
        VALID_SORT_BY_VALUES.add(SORT_BY_FORM_PROPERTY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_TIME);
        VALID_SORT_BY_VALUES.add(SORT_PARTIALLY_BY_OCCURENCE);
    }
}

