/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.identity;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;

public class GroupQueryDto
extends AbstractQueryDto<GroupQuery> {
    private static final String SORT_BY_GROUP_ID_VALUE = "id";
    private static final String SORT_BY_GROUP_NAME_VALUE = "name";
    private static final String SORT_BY_GROUP_TYPE_VALUE = "type";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    protected String id;
    protected String name;
    protected String nameLike;
    protected String type;
    protected String member;

    public GroupQueryDto() {
    }

    public GroupQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="id")
    public void setId(String groupId) {
        this.id = groupId;
    }

    @CamundaQueryParam(value="name")
    public void setName(String groupName) {
        this.name = groupName;
    }

    @CamundaQueryParam(value="nameLike")
    public void setNameLike(String groupNameLike) {
        this.nameLike = groupNameLike;
    }

    @CamundaQueryParam(value="type")
    public void setType(String groupType) {
        this.type = groupType;
    }

    @CamundaQueryParam(value="member")
    public void setGroupMember(String member) {
        this.member = member;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected GroupQuery createNewQuery(ProcessEngine engine) {
        return engine.getIdentityService().createGroupQuery();
    }

    protected void applyFilters(GroupQuery query) {
        if (this.id != null) {
            query.groupId(this.id);
        }
        if (this.name != null) {
            query.groupName(this.name);
        }
        if (this.nameLike != null) {
            query.groupNameLike(this.nameLike);
        }
        if (this.type != null) {
            query.groupType(this.type);
        }
        if (this.member != null) {
            query.groupMember(this.member);
        }
    }

    protected void applySortBy(GroupQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_GROUP_ID_VALUE)) {
            query.orderByGroupId();
        } else if (sortBy.equals(SORT_BY_GROUP_NAME_VALUE)) {
            query.orderByGroupName();
        } else if (sortBy.equals(SORT_BY_GROUP_TYPE_VALUE)) {
            query.orderByGroupType();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_GROUP_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_GROUP_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_GROUP_TYPE_VALUE);
    }
}

