/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.filter.FilterQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;

public class FilterQueryDto
extends AbstractQueryDto<FilterQuery> {
    public static final String SORT_BY_ID_VALUE = "filterId";
    public static final String SORT_BY_RESOURCE_TYPE_VALUE = "resourceType";
    public static final String SORT_BY_NAME_VALUE = "name";
    public static final String SORT_BY_OWNER_VALUE = "owner";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    protected String filterId;
    protected String resourceType;
    protected String name;
    protected String nameLike;
    protected String owner;

    public FilterQueryDto() {
    }

    public FilterQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="filterId")
    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    @CamundaQueryParam(value="resourceType")
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @CamundaQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @CamundaQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @CamundaQueryParam(value="owner")
    public void setOwner(String owner) {
        this.owner = owner;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected FilterQuery createNewQuery(ProcessEngine engine) {
        return engine.getFilterService().createFilterQuery();
    }

    protected void applyFilters(FilterQuery query) {
        if (this.filterId != null) {
            query.filterId(this.filterId);
        }
        if (this.resourceType != null) {
            query.filterResourceType(this.resourceType);
        }
        if (this.name != null) {
            query.filterName(this.name);
        }
        if (this.nameLike != null) {
            query.filterNameLike(this.nameLike);
        }
        if (this.owner != null) {
            query.filterOwner(this.owner);
        }
    }

    protected void applySortBy(FilterQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_ID_VALUE)) {
            query.orderByFilterId();
        } else if (sortBy.equals(SORT_BY_RESOURCE_TYPE_VALUE)) {
            query.orderByFilterResourceType();
        } else if (sortBy.equals(SORT_BY_NAME_VALUE)) {
            query.orderByFilterName();
        } else if (sortBy.equals(SORT_BY_OWNER_VALUE)) {
            query.orderByFilterOwner();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_RESOURCE_TYPE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_OWNER_VALUE);
    }
}

