/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime.modification;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.runtime.modification.ProcessInstanceModificationInstructionDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;

@JsonTypeName(value="cancel")
public class CancellationInstructionDto
extends ProcessInstanceModificationInstructionDto {
    public void applyTo(ProcessInstanceModificationBuilder builder, ProcessEngine engine, ObjectMapper mapper) {
        this.validateParameters();
        if (this.activityId != null) {
            builder.cancelAllForActivity(this.activityId);
        } else if (this.activityInstanceId != null) {
            builder.cancelActivityInstance(this.activityInstanceId);
        } else if (this.transitionInstanceId != null) {
            builder.cancelTransitionInstance(this.transitionInstanceId);
        }
    }

    protected void validateParameters() {
        boolean oneParameterSet = false;
        boolean moreThanOneParametersSet = false;
        if (this.activityId != null) {
            oneParameterSet = true;
        }
        if (this.activityInstanceId != null) {
            moreThanOneParametersSet |= oneParameterSet;
            oneParameterSet = true;
        }
        if (this.transitionInstanceId != null) {
            moreThanOneParametersSet |= oneParameterSet;
            oneParameterSet = true;
        }
        if (moreThanOneParametersSet || !oneParameterSet) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, this.buildErrorMessage("exactly one, 'activityId', 'activityInstanceId', or 'transitionInstanceId', is required"));
        }
    }

    public void applyTo(ProcessInstantiationBuilder builder, ProcessEngine engine, ObjectMapper mapper) {
    }
}

