/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.task;

import java.util.Date;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.rest.dto.converter.DelegationStateConverter;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;

public class TaskDto {
    private String id;
    private String name;
    private String assignee;
    private Date created;
    private Date due;
    private Date followUp;
    private String delegationState;
    private String description;
    private String executionId;
    private String owner;
    private String parentTaskId;
    private int priority;
    private String processDefinitionId;
    private String processInstanceId;
    private String taskDefinitionKey;
    private String caseExecutionId;
    private String caseInstanceId;
    private String caseDefinitionId;
    private boolean suspended;
    private String formKey;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getDue() {
        return this.due;
    }

    public void setDue(Date due) {
        this.due = due;
    }

    public String getDelegationState() {
        return this.delegationState;
    }

    public void setDelegationState(String delegationState) {
        this.delegationState = delegationState;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public Date getFollowUp() {
        return this.followUp;
    }

    public void setFollowUp(Date followUp) {
        this.followUp = followUp;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public static TaskDto fromEntity(Task task) {
        TaskDto dto = new TaskDto();
        dto.id = task.getId();
        dto.name = task.getName();
        dto.assignee = task.getAssignee();
        dto.created = task.getCreateTime();
        dto.due = task.getDueDate();
        dto.followUp = task.getFollowUpDate();
        if (task.getDelegationState() != null) {
            dto.delegationState = task.getDelegationState().toString();
        }
        dto.description = task.getDescription();
        dto.executionId = task.getExecutionId();
        dto.owner = task.getOwner();
        dto.parentTaskId = task.getParentTaskId();
        dto.priority = task.getPriority();
        dto.processDefinitionId = task.getProcessDefinitionId();
        dto.processInstanceId = task.getProcessInstanceId();
        dto.taskDefinitionKey = task.getTaskDefinitionKey();
        dto.caseDefinitionId = task.getCaseDefinitionId();
        dto.caseExecutionId = task.getCaseExecutionId();
        dto.caseInstanceId = task.getCaseInstanceId();
        dto.suspended = task.isSuspended();
        try {
            dto.formKey = task.getFormKey();
        }
        catch (BadUserRequestException badUserRequestException) {
            // empty catch block
        }
        return dto;
    }

    public void updateTask(Task task) {
        task.setName(this.getName());
        task.setDescription(this.getDescription());
        task.setPriority(this.getPriority());
        task.setAssignee(this.getAssignee());
        task.setOwner(this.getOwner());
        DelegationState state = null;
        if (this.getDelegationState() != null) {
            DelegationStateConverter converter = new DelegationStateConverter();
            state = converter.convertQueryParameterToType(this.getDelegationState());
        }
        task.setDelegationState(state);
        task.setDueDate(this.getDue());
        task.setFollowUpDate(this.getFollowUp());
        task.setParentTaskId(this.getParentTaskId());
        task.setCaseInstanceId(this.getCaseInstanceId());
    }
}

