/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.hal;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.hal.Hal;
import org.camunda.bpm.engine.rest.hal.HalLink;
import org.camunda.bpm.engine.rest.hal.HalLinker;
import org.camunda.bpm.engine.rest.hal.HalRelation;

public abstract class HalResource<T extends HalResource<?>> {
    protected Map<String, HalLink> _links;
    protected Map<String, Object> _embedded;
    protected transient HalLinker linker = Hal.getInstance().createLinker(this);

    public Map<String, HalLink> get_links() {
        return this._links;
    }

    public Map<String, Object> get_embedded() {
        return this._embedded;
    }

    public void addLink(String rel, String href) {
        if (this._links == null) {
            this._links = new TreeMap();
        }
        this._links.put(rel, new HalLink(href));
    }

    public void addLink(String rel, URI hrefUri) {
        this.addLink(rel, hrefUri.toString());
    }

    public void addEmbedded(String name, HalResource<?> embedded) {
        this.linker.mergeLinks(embedded);
        this.addEmbeddedObject(name, embedded);
    }

    private void addEmbeddedObject(String name, Object embedded) {
        if (this._embedded == null) {
            this._embedded = new TreeMap();
        }
        this._embedded.put(name, embedded);
    }

    public void addEmbedded(String name, List<HalResource<?>> embeddedCollection) {
        for (HalResource<?> resource : embeddedCollection) {
            this.linker.mergeLinks(resource);
        }
        this.addEmbeddedObject(name, embeddedCollection);
    }

    public Object getEmbedded(String name) {
        return this._embedded.get(name);
    }

    public T embed(HalRelation relation, ProcessEngine processEngine) {
        List resolvedLinks = this.linker.resolve(relation, processEngine);
        if (resolvedLinks != null && resolvedLinks.size() > 0) {
            this.addEmbedded(relation.relName, resolvedLinks);
        }
        return (T)this;
    }
}

