/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.hal;

import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.hal.HalRelation;
import org.camunda.bpm.engine.rest.hal.HalResource;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.variable.value.TypedValue;

/*
 * Exception performing whole class analysis ignored.
 */
public class HalVariableValue
extends HalResource<HalVariableValue> {
    public static HalRelation REL_SELF = HalRelation.build((String)"self", VariableResource.class, (UriBuilder)UriBuilder.fromPath((String)"/{scopeResourcePath}").path("{scopeId}").path("{variablesName}").path("{variableName}"));
    protected String name;
    protected Object value;
    protected String type;
    protected Map<String, Object> valueInfo;

    public static HalVariableValue generateVariableValue(VariableInstance variableInstance, String variableScopeId) {
        if (variableScopeId.equals(variableInstance.getTaskId())) {
            return HalVariableValue.generateTaskVariableValue((VariableInstance)variableInstance, (String)variableScopeId);
        }
        if (variableScopeId.equals(variableInstance.getProcessInstanceId())) {
            return HalVariableValue.generateProcessInstanceVariableValue((VariableInstance)variableInstance, (String)variableScopeId);
        }
        if (variableScopeId.equals(variableInstance.getExecutionId())) {
            return HalVariableValue.generateExecutionVariableValue((VariableInstance)variableInstance, (String)variableScopeId);
        }
        if (variableScopeId.equals(variableInstance.getCaseInstanceId())) {
            return HalVariableValue.generateCaseInstanceVariableValue((VariableInstance)variableInstance, (String)variableScopeId);
        }
        if (variableScopeId.equals(variableInstance.getCaseExecutionId())) {
            return HalVariableValue.generateCaseExecutionVariableValue((VariableInstance)variableInstance, (String)variableScopeId);
        }
        throw new RestException("Variable scope id '" + variableScopeId + "' does not match with variable instance '" + variableInstance + "'");
    }

    public static HalVariableValue generateTaskVariableValue(VariableInstance variableInstance, String taskId) {
        return HalVariableValue.fromVariableInstance((VariableInstance)variableInstance).link(REL_SELF, "/task", taskId, "localVariables");
    }

    public static HalVariableValue generateExecutionVariableValue(VariableInstance variableInstance, String executionId) {
        return HalVariableValue.fromVariableInstance((VariableInstance)variableInstance).link(REL_SELF, "/execution", executionId, "localVariables");
    }

    public static HalVariableValue generateProcessInstanceVariableValue(VariableInstance variableInstance, String processInstanceId) {
        return HalVariableValue.fromVariableInstance((VariableInstance)variableInstance).link(REL_SELF, "/process-instance", processInstanceId, "variables");
    }

    public static HalVariableValue generateCaseExecutionVariableValue(VariableInstance variableInstance, String caseExecutionId) {
        return HalVariableValue.fromVariableInstance((VariableInstance)variableInstance).link(REL_SELF, "/case-execution", caseExecutionId, "localVariables");
    }

    public static HalVariableValue generateCaseInstanceVariableValue(VariableInstance variableInstance, String caseInstanceId) {
        return HalVariableValue.fromVariableInstance((VariableInstance)variableInstance).link(REL_SELF, "/case-instance", caseInstanceId, "variables");
    }

    private HalVariableValue link(HalRelation relation, String resourcePath, String resourceId, String variablesPath) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        this.linker.createLink(relation, new String[]{resourcePath, resourceId, variablesPath, this.name});
        return this;
    }

    public static HalVariableValue fromVariableInstance(VariableInstance variableInstance) {
        HalVariableValue dto = new HalVariableValue();
        VariableValueDto variableValueDto = VariableValueDto.fromTypedValue((TypedValue)variableInstance.getTypedValue());
        dto.name = variableInstance.getName();
        dto.value = variableValueDto.getValue();
        dto.type = variableValueDto.getType();
        dto.valueInfo = variableValueDto.getValueInfo();
        return dto;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getValueInfo() {
        return this.valueInfo;
    }
}

