/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.hal.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.rest.cache.Cache;
import org.camunda.bpm.engine.rest.hal.Hal;
import org.camunda.bpm.engine.rest.hal.cache.HalRelationCacheConfiguration;
import org.camunda.bpm.engine.rest.hal.cache.HalRelationCacheConfigurationException;

public class HalRelationCacheBootstrap
implements ServletContextListener {
    public static final String CONTEXT_PARAM_NAME = "org.camunda.bpm.engine.rest.hal.cache.config";
    protected ObjectMapper objectMapper = new ObjectMapper();

    public void contextInitialized(ServletContextEvent sce) {
        String contextParameter = sce.getServletContext().getInitParameter(CONTEXT_PARAM_NAME);
        if (contextParameter != null) {
            this.configureCaches(contextParameter);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        Hal.getInstance().destroyHalRelationCaches();
    }

    public void configureCaches(String contextParameter) {
        HalRelationCacheConfiguration configuration = new HalRelationCacheConfiguration(contextParameter);
        this.configureCaches(configuration);
    }

    public void configureCaches(HalRelationCacheConfiguration configuration) {
        Class cacheClass = configuration.getCacheImplementationClass();
        for (Map.Entry cacheConfiguration : configuration.getCacheConfigurations().entrySet()) {
            Cache cache = this.createCache(cacheClass, (Map)cacheConfiguration.getValue());
            this.registerCache((Class)cacheConfiguration.getKey(), cache);
        }
    }

    protected Cache createCache(Class<? extends Cache> cacheClass, Map<String, Object> cacheConfiguration) {
        Cache cache = this.createCacheInstance(cacheClass);
        this.configureCache(cache, cacheConfiguration);
        return cache;
    }

    protected void configureCache(Cache cache, Map<String, Object> cacheConfiguration) {
        for (Map.Entry<String, Object> configuration : cacheConfiguration.entrySet()) {
            this.configureCache(cache, configuration.getKey(), configuration.getValue());
        }
    }

    protected Cache createCacheInstance(Class<? extends Cache> cacheClass) {
        try {
            return (Cache)ReflectUtil.instantiate(cacheClass);
        }
        catch (ProcessEngineException e) {
            throw new HalRelationCacheConfigurationException("Unable to instantiate cache class " + cacheClass.getName(), (Throwable)e);
        }
    }

    protected void configureCache(Cache cache, String property, Object value) {
        Method setter;
        try {
            setter = ReflectUtil.getSingleSetter((String)property, cache.getClass());
        }
        catch (ProcessEngineException e) {
            throw new HalRelationCacheConfigurationException("Unable to find setter for property " + property, (Throwable)e);
        }
        if (setter == null) {
            throw new HalRelationCacheConfigurationException("Unable to find setter for property " + property);
        }
        try {
            setter.invoke((Object)cache, value);
        }
        catch (IllegalAccessException e) {
            throw new HalRelationCacheConfigurationException("Unable to access setter for property " + property);
        }
        catch (InvocationTargetException e) {
            throw new HalRelationCacheConfigurationException("Unable to invoke setter for property " + property);
        }
    }

    protected void registerCache(Class<?> halResourceClass, Cache cache) {
        Hal.getInstance().registerHalRelationCache(halResourceClass, cache);
    }
}

