/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.rest.MessageRestService;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.message.CorrelationMessageDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.camunda.bpm.engine.variable.VariableMap;

public class MessageRestServiceImpl
extends AbstractRestProcessEngineAware
implements MessageRestService {
    public MessageRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    public void deliverMessage(CorrelationMessageDto messageDto) {
        if (messageDto.getMessageName() == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No message name supplied");
        }
        RuntimeService runtimeService = this.processEngine.getRuntimeService();
        try {
            ObjectMapper objectMapper = this.getObjectMapper();
            VariableMap correlationKeys = VariableValueDto.toMap((Map)messageDto.getCorrelationKeys(), (ProcessEngine)this.processEngine, (ObjectMapper)objectMapper);
            VariableMap processVariables = VariableValueDto.toMap((Map)messageDto.getProcessVariables(), (ProcessEngine)this.processEngine, (ObjectMapper)objectMapper);
            MessageCorrelationBuilder correlation = runtimeService.createMessageCorrelation(messageDto.getMessageName()).setVariables((Map)processVariables).processInstanceBusinessKey(messageDto.getBusinessKey());
            if (correlationKeys != null && !correlationKeys.isEmpty()) {
                for (Map.Entry correlationKey : correlationKeys.entrySet()) {
                    String name = (String)correlationKey.getKey();
                    Object value = correlationKey.getValue();
                    correlation.processInstanceVariableEquals(name, value);
                }
            }
            if (!messageDto.isAll()) {
                correlation.correlate();
            } else {
                correlation.correlateAll();
            }
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot deliver message: %s", e.getMessage());
            throw new InvalidRequestException(e.getStatus(), (Exception)((Object)e), errorMessage);
        }
        catch (MismatchingMessageCorrelationException e) {
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e));
        }
    }
}

