/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.rest.TaskRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.task.TaskDto;
import org.camunda.bpm.engine.rest.dto.task.TaskQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.hal.Hal;
import org.camunda.bpm.engine.rest.hal.task.HalTaskList;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.task.TaskResource;
import org.camunda.bpm.engine.rest.sub.task.impl.TaskResourceImpl;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;

public class TaskRestServiceImpl
extends AbstractRestProcessEngineAware
implements TaskRestService {
    public static final List<Variant> VARIANTS = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, Hal.APPLICATION_HAL_JSON_TYPE}).add().build();

    public TaskRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    public Object getTasks(Request request, UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        Variant variant = request.selectVariant(VARIANTS);
        if (variant != null) {
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.getJsonTasks(uriInfo, firstResult, maxResults);
            }
            if (Hal.APPLICATION_HAL_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.getHalTasks(uriInfo, firstResult, maxResults);
            }
        }
        throw new InvalidRequestException(Response.Status.NOT_ACCEPTABLE, "No acceptable content-type found");
    }

    public List<TaskDto> getJsonTasks(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        TaskQueryDto queryDto = new TaskQueryDto(this.getObjectMapper(), uriInfo.getQueryParameters());
        return this.queryTasks(queryDto, firstResult, maxResults);
    }

    public HalTaskList getHalTasks(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        TaskQueryDto queryDto = new TaskQueryDto(this.getObjectMapper(), uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        TaskQuery query = (TaskQuery)queryDto.toQuery(engine);
        List matchingTasks = this.executeTaskQuery(firstResult, maxResults, query);
        long count = query.count();
        return HalTaskList.generate((List)matchingTasks, (long)count, (ProcessEngine)engine);
    }

    public List<TaskDto> queryTasks(TaskQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        TaskQuery query = (TaskQuery)queryDto.toQuery(engine);
        List matchingTasks = this.executeTaskQuery(firstResult, maxResults, query);
        ArrayList<TaskDto> tasks = new ArrayList<TaskDto>();
        for (Task task : matchingTasks) {
            TaskDto returnTask = TaskDto.fromEntity((Task)task);
            tasks.add(returnTask);
        }
        return tasks;
    }

    protected List<Task> executeTaskQuery(Integer firstResult, Integer maxResults, TaskQuery query) {
        query.initializeFormKeys();
        List matchingTasks = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        return matchingTasks;
    }

    protected List<Task> executePaginatedQuery(TaskQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    public CountResultDto getTasksCount(UriInfo uriInfo) {
        TaskQueryDto queryDto = new TaskQueryDto(this.getObjectMapper(), uriInfo.getQueryParameters());
        return this.queryTasksCount(queryDto);
    }

    public CountResultDto queryTasksCount(TaskQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        TaskQuery query = (TaskQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    public TaskResource getTask(String id) {
        return new TaskResourceImpl(this.getProcessEngine(), id, this.relativeRootResourcePath, this.getObjectMapper());
    }

    public void createTask(TaskDto taskDto) {
        ProcessEngine engine = this.getProcessEngine();
        TaskService taskService = engine.getTaskService();
        Task newTask = taskService.newTask(taskDto.getId());
        taskDto.updateTask(newTask);
        try {
            taskService.saveTask(newTask);
        }
        catch (NotValidException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Could not save task: " + e.getMessage());
        }
    }
}

