/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricCaseActivityInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricCaseActivityInstanceQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricCaseActivityInstanceRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricCaseActivityInstanceResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricCaseActivityInstanceResourceImpl;

public class HistoricCaseActivityInstanceRestServiceImpl
implements HistoricCaseActivityInstanceRestService {
    protected ProcessEngine processEngine;
    protected ObjectMapper objectMapper;

    public HistoricCaseActivityInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    public HistoricCaseActivityInstanceResource getHistoricCaseInstance(String caseActivityInstanceId) {
        return new HistoricCaseActivityInstanceResourceImpl(this.processEngine, caseActivityInstanceId);
    }

    public List<HistoricCaseActivityInstanceDto> getHistoricCaseActivityInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricCaseActivityInstanceQueryDto queryHistoricCaseActivityInstanceDto = new HistoricCaseActivityInstanceQueryDto(this.objectMapper, uriInfo.getQueryParameters());
        return this.queryHistoricCaseActivityInstances(queryHistoricCaseActivityInstanceDto, firstResult, maxResults);
    }

    public List<HistoricCaseActivityInstanceDto> queryHistoricCaseActivityInstances(HistoricCaseActivityInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        HistoricCaseActivityInstanceQuery query = (HistoricCaseActivityInstanceQuery)queryDto.toQuery(this.processEngine);
        List matchingHistoricCaseActivityInstances = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<HistoricCaseActivityInstanceDto> historicCaseActivityInstanceResults = new ArrayList<HistoricCaseActivityInstanceDto>();
        for (HistoricCaseActivityInstance historicCaseActivityInstance : matchingHistoricCaseActivityInstances) {
            HistoricCaseActivityInstanceDto resultHistoricCaseActivityInstance = HistoricCaseActivityInstanceDto.fromHistoricCaseActivityInstance((HistoricCaseActivityInstance)historicCaseActivityInstance);
            historicCaseActivityInstanceResults.add(resultHistoricCaseActivityInstance);
        }
        return historicCaseActivityInstanceResults;
    }

    private List<HistoricCaseActivityInstance> executePaginatedQuery(HistoricCaseActivityInstanceQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    public CountResultDto getHistoricCaseActivityInstancesCount(UriInfo uriInfo) {
        HistoricCaseActivityInstanceQueryDto queryDto = new HistoricCaseActivityInstanceQueryDto(this.objectMapper, uriInfo.getQueryParameters());
        return this.queryHistoricCaseActivityInstancesCount(queryDto);
    }

    public CountResultDto queryHistoricCaseActivityInstancesCount(HistoricCaseActivityInstanceQueryDto queryDto) {
        HistoricCaseActivityInstanceQuery query = (HistoricCaseActivityInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        return new CountResultDto(count);
    }
}

