/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricCaseInstanceQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricCaseInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricCaseInstanceQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricCaseInstanceRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricCaseInstanceResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricCaseInstanceResourceImpl;

public class HistoricCaseInstanceRestServiceImpl
implements HistoricCaseInstanceRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricCaseInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    public HistoricCaseInstanceResource getHistoricCaseInstance(String caseInstanceId) {
        return new HistoricCaseInstanceResourceImpl(this.processEngine, caseInstanceId);
    }

    public List<HistoricCaseInstanceDto> getHistoricCaseInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricCaseInstanceQueryDto queryHistoricCaseInstanceDto = new HistoricCaseInstanceQueryDto(this.objectMapper, uriInfo.getQueryParameters());
        return this.queryHistoricCaseInstances(queryHistoricCaseInstanceDto, firstResult, maxResults);
    }

    public List<HistoricCaseInstanceDto> queryHistoricCaseInstances(HistoricCaseInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        HistoricCaseInstanceQuery query = (HistoricCaseInstanceQuery)queryDto.toQuery(this.processEngine);
        List matchingHistoricCaseInstances = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<HistoricCaseInstanceDto> historicCaseInstanceDtoResults = new ArrayList<HistoricCaseInstanceDto>();
        for (HistoricCaseInstance historicCaseInstance : matchingHistoricCaseInstances) {
            HistoricCaseInstanceDto resultHistoricCaseInstanceDto = HistoricCaseInstanceDto.fromHistoricCaseInstance((HistoricCaseInstance)historicCaseInstance);
            historicCaseInstanceDtoResults.add(resultHistoricCaseInstanceDto);
        }
        return historicCaseInstanceDtoResults;
    }

    private List<HistoricCaseInstance> executePaginatedQuery(HistoricCaseInstanceQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    public CountResultDto getHistoricCaseInstancesCount(UriInfo uriInfo) {
        HistoricCaseInstanceQueryDto queryDto = new HistoricCaseInstanceQueryDto(this.objectMapper, uriInfo.getQueryParameters());
        return this.queryHistoricCaseInstancesCount(queryDto);
    }

    public CountResultDto queryHistoricCaseInstancesCount(HistoricCaseInstanceQueryDto queryDto) {
        HistoricCaseInstanceQuery query = (HistoricCaseInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        return new CountResultDto(count);
    }
}

