/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricVariableInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricVariableInstanceQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricVariableInstanceRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricVariableInstanceResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricVariableInstanceResourceImpl;

public class HistoricVariableInstanceRestServiceImpl
implements HistoricVariableInstanceRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricVariableInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    public HistoricVariableInstanceResource variableInstanceResource(String variableId) {
        return new HistoricVariableInstanceResourceImpl(variableId, this.processEngine);
    }

    public List<HistoricVariableInstanceDto> getHistoricVariableInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        HistoricVariableInstanceQueryDto queryDto = new HistoricVariableInstanceQueryDto(this.objectMapper, uriInfo.getQueryParameters());
        return this.queryHistoricVariableInstances(queryDto, firstResult, maxResults, deserializeObjectValues);
    }

    public List<HistoricVariableInstanceDto> queryHistoricVariableInstances(HistoricVariableInstanceQueryDto queryDto, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricVariableInstanceQuery query = (HistoricVariableInstanceQuery)queryDto.toQuery(this.processEngine);
        query.disableBinaryFetching();
        if (!deserializeObjectValues) {
            query.disableCustomObjectDeserialization();
        }
        List matchingHistoricVariableInstances = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<HistoricVariableInstanceDto> historicVariableInstanceDtoResults = new ArrayList<HistoricVariableInstanceDto>();
        for (HistoricVariableInstance historicVariableInstance : matchingHistoricVariableInstances) {
            HistoricVariableInstanceDto resultHistoricVariableInstance = HistoricVariableInstanceDto.fromHistoricVariableInstance((HistoricVariableInstance)historicVariableInstance);
            historicVariableInstanceDtoResults.add(resultHistoricVariableInstance);
        }
        return historicVariableInstanceDtoResults;
    }

    private List<HistoricVariableInstance> executePaginatedQuery(HistoricVariableInstanceQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    public CountResultDto getHistoricVariableInstancesCount(UriInfo uriInfo) {
        HistoricVariableInstanceQueryDto queryDto = new HistoricVariableInstanceQueryDto(this.objectMapper, uriInfo.getQueryParameters());
        return this.queryHistoricVariableInstancesCount(queryDto);
    }

    public CountResultDto queryHistoricVariableInstancesCount(HistoricVariableInstanceQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricVariableInstanceQuery query = (HistoricVariableInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

