/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.UserOperationLogEntryDto;
import org.camunda.bpm.engine.rest.dto.history.UserOperationLogQueryDto;
import org.camunda.bpm.engine.rest.history.UserOperationLogRestService;

public class UserOperationLogRestServiceImpl
implements UserOperationLogRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public UserOperationLogRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    public CountResultDto queryUserOperationCount(UriInfo uriInfo) {
        UserOperationLogQueryDto queryDto = new UserOperationLogQueryDto(this.objectMapper, uriInfo.getQueryParameters());
        UserOperationLogQuery query = (UserOperationLogQuery)queryDto.toQuery(this.processEngine);
        return new CountResultDto(query.count());
    }

    public List<UserOperationLogEntryDto> queryUserOperationEntries(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        UserOperationLogQueryDto queryDto = new UserOperationLogQueryDto(this.objectMapper, uriInfo.getQueryParameters());
        UserOperationLogQuery query = (UserOperationLogQuery)queryDto.toQuery(this.processEngine);
        if (firstResult == null && maxResults == null) {
            return UserOperationLogEntryDto.map((List)query.list());
        }
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return UserOperationLogEntryDto.map((List)query.listPage(firstResult.intValue(), maxResults.intValue()));
    }
}

