/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.rest.dto.PatchVariablesDto;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.mapper.MultipartFormData;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.BytesValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class AbstractVariablesResource
implements VariableResource {
    protected ProcessEngine engine;
    protected String resourceId;
    protected ObjectMapper objectMapper;

    public AbstractVariablesResource(ProcessEngine engine, String resourceId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.resourceId = resourceId;
        this.objectMapper = objectMapper;
    }

    public Map<String, VariableValueDto> getVariables(boolean deserializeValues) {
        VariableMap variables = this.getVariableEntities(deserializeValues);
        HashMap<String, VariableValueDto> values = new HashMap<String, VariableValueDto>();
        for (String variableName : variables.keySet()) {
            VariableValueDto valueDto = VariableValueDto.fromTypedValue((TypedValue)variables.getValueTyped(variableName));
            values.put(variableName, valueDto);
        }
        return values;
    }

    public VariableValueDto getVariable(String variableName, boolean deserializeValue) {
        TypedValue value = this.getTypedValueForVariable(variableName, deserializeValue);
        return VariableValueDto.fromTypedValue((TypedValue)value);
    }

    protected TypedValue getTypedValueForVariable(String variableName, boolean deserializeValue) {
        TypedValue value = null;
        try {
            value = this.getVariableEntity(variableName, deserializeValue);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot get %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
        if (value == null) {
            String errorMessage = String.format("%s variable with name %s does not exist", this.getResourceTypeName(), variableName);
            throw new InvalidRequestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return value;
    }

    public InputStream getVariableBinary(String variableName) {
        TypedValue typedValue = this.getTypedValueForVariable(variableName, false);
        if (typedValue instanceof BytesValue) {
            byte[] valueBytes = (byte[])((BytesValue)typedValue).getValue();
            if (valueBytes == null) {
                valueBytes = new byte[]{};
            }
            return new ByteArrayInputStream(valueBytes);
        }
        throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Variable '" + variableName + "' is not of type 'Bytes' but of type '" + typedValue.getType() + "'.");
    }

    public void putVariable(String variableName, VariableValueDto variable) {
        try {
            TypedValue typedValue = variable.toTypedValue(this.engine, this.objectMapper);
            this.setVariableEntity(variableName, typedValue);
        }
        catch (RestException e) {
            throw new InvalidRequestException(e.getStatus(), (Exception)((Object)e), String.format("Cannot put %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage()));
        }
        catch (BadUserRequestException e) {
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), String.format("Cannot put %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage()));
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), String.format("Cannot put %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage()));
        }
    }

    public void setBinaryVariable(String variableKey, MultipartFormData payload) {
        MultipartFormData.FormPart dataPart = payload.getNamedPart("data");
        MultipartFormData.FormPart valueTypePart = payload.getNamedPart("type");
        if (valueTypePart != null) {
            Object object = null;
            if (dataPart.getContentType() == null || !dataPart.getContentType().toLowerCase().contains("application/json")) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Unrecognized content type for serialized java type: " + dataPart.getContentType());
            }
            object = this.deserializeJsonObject(valueTypePart.getTextContent(), dataPart.getBinaryContent());
            if (object != null) {
                this.setVariableEntity(variableKey, Variables.objectValue((Object)object).create());
            }
        } else {
            try {
                this.setVariableEntity(variableKey, (TypedValue)Variables.byteArrayValue((byte[])dataPart.getBinaryContent()));
            }
            catch (AuthorizationException e) {
                throw e;
            }
            catch (ProcessEngineException e) {
                String errorMessage = String.format("Cannot put %s variable %s: %s", this.getResourceTypeName(), variableKey, e.getMessage());
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
            }
        }
    }

    protected Object deserializeJsonObject(String className, byte[] data) {
        try {
            JavaType type = TypeFactory.defaultInstance().constructFromCanonical(className);
            return this.objectMapper.readValue(new String(data, Charset.forName("UTF-8")), type);
        }
        catch (Exception e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, "Could not deserialize JSON object: " + e.getMessage());
        }
    }

    public void deleteVariable(String variableName) {
        try {
            this.removeVariableEntity(variableName);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot delete %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
    }

    public void modifyVariables(PatchVariablesDto patch) {
        VariableMap variableModifications = null;
        try {
            variableModifications = VariableValueDto.toMap((Map)patch.getModifications(), (ProcessEngine)this.engine, (ObjectMapper)this.objectMapper);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot modify variables for %s: %s", this.getResourceTypeName(), e.getMessage());
            throw new InvalidRequestException(e.getStatus(), (Exception)((Object)e), errorMessage);
        }
        List variableDeletions = patch.getDeletions();
        try {
            this.updateVariableEntities(variableModifications, variableDeletions);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot modify variables for %s %s: %s", this.getResourceTypeName(), this.resourceId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
    }

    protected abstract VariableMap getVariableEntities(boolean var1);

    protected abstract void updateVariableEntities(VariableMap var1, List<String> var2);

    protected abstract TypedValue getVariableEntity(String var1, boolean var2);

    protected abstract void setVariableEntity(String var1, TypedValue var2);

    protected abstract void removeVariableEntity(String var1);

    protected abstract String getResourceTypeName();
}

