/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.repository.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.engine.rest.dto.repository.DeploymentResourceDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.repository.DeploymentResourcesResource;

public class DeploymentResourcesResourceImpl
implements DeploymentResourcesResource {
    protected final ProcessEngine engine;
    protected final String deploymentId;

    public DeploymentResourcesResourceImpl(ProcessEngine engine, String deploymentId) {
        this.engine = engine;
        this.deploymentId = deploymentId;
    }

    public List<DeploymentResourceDto> getDeploymentResources() {
        List resources = this.engine.getRepositoryService().getDeploymentResources(this.deploymentId);
        ArrayList<DeploymentResourceDto> deploymentResources = new ArrayList<DeploymentResourceDto>();
        for (Resource resource : resources) {
            deploymentResources.add(DeploymentResourceDto.fromResources((Resource)resource));
        }
        if (!deploymentResources.isEmpty()) {
            return deploymentResources;
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Deployment resources for deployment id '" + this.deploymentId + "' do not exist.");
    }

    public DeploymentResourceDto getDeploymentResource(String resourceId) {
        List deploymentResources = this.getDeploymentResources();
        for (DeploymentResourceDto deploymentResource : deploymentResources) {
            if (!deploymentResource.getId().equals(resourceId)) continue;
            return deploymentResource;
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Deployment resource with resource id '" + resourceId + "' for deployment id '" + this.deploymentId + "' does not exist.");
    }

    public InputStream getDeploymentResourceData(String resourceId) {
        InputStream resourceAsStream = this.engine.getRepositoryService().getResourceAsStreamById(this.deploymentId, resourceId);
        if (resourceAsStream != null) {
            return resourceAsStream;
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Deployment resource '" + resourceId + "' for deployment id '" + this.deploymentId + "' does not exist.");
    }
}

