/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.rest.dto.runtime.CaseExecutionTriggerDto;
import org.camunda.bpm.engine.rest.dto.runtime.CaseInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.TriggerVariableValueDto;
import org.camunda.bpm.engine.rest.dto.runtime.VariableNameDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.rest.sub.runtime.CaseInstanceResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.CaseExecutionVariablesResource;
import org.camunda.bpm.engine.runtime.CaseExecutionCommandBuilder;
import org.camunda.bpm.engine.runtime.CaseInstance;

public class CaseInstanceResourceImpl
implements CaseInstanceResource {
    protected ProcessEngine engine;
    protected String caseInstanceId;
    protected ObjectMapper objectMapper;

    public CaseInstanceResourceImpl(ProcessEngine engine, String caseInstanceId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.caseInstanceId = caseInstanceId;
        this.objectMapper = objectMapper;
    }

    public CaseInstanceDto getCaseInstance() {
        CaseService caseService = this.engine.getCaseService();
        CaseInstance instance = (CaseInstance)caseService.createCaseInstanceQuery().caseInstanceId(this.caseInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Case instance with id " + this.caseInstanceId + " does not exist.");
        }
        CaseInstanceDto result = CaseInstanceDto.fromCaseInstance((CaseInstance)instance);
        return result;
    }

    public void complete(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseInstanceId);
            this.initializeCommand(commandBuilder, triggerDto, "complete");
            commandBuilder.complete();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException("complete", Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException("complete", Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException("complete", Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException("complete", Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    public void close(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseInstanceId);
            this.initializeCommand(commandBuilder, triggerDto, "close");
            commandBuilder.close();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException("close", Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException("close", Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException("close", Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException("close", Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    protected InvalidRequestException createInvalidRequestException(String transition, Response.Status status, ProcessEngineException cause) {
        String errorMessage = String.format("Cannot %s case instance %s: %s", transition, this.caseInstanceId, cause.getMessage());
        return new InvalidRequestException(status, (Exception)((Object)cause), errorMessage);
    }

    protected RestException createRestException(String transition, Response.Status status, ProcessEngineException cause) {
        String errorMessage = String.format("Cannot %s case instance %s: %s", transition, this.caseInstanceId, cause.getMessage());
        return new RestException(status, (Exception)((Object)cause), errorMessage);
    }

    protected void initializeCommand(CaseExecutionCommandBuilder commandBuilder, CaseExecutionTriggerDto triggerDto, String transition) {
        List deletions;
        Map variables = triggerDto.getVariables();
        if (variables != null && !variables.isEmpty()) {
            this.initializeCommandWithVariables(commandBuilder, variables, transition);
        }
        if ((deletions = triggerDto.getDeletions()) != null && !deletions.isEmpty()) {
            this.initializeCommandWithDeletions(commandBuilder, deletions, transition);
        }
    }

    protected void initializeCommandWithVariables(CaseExecutionCommandBuilder commandBuilder, Map<String, TriggerVariableValueDto> variables, String transition) {
        for (String variableName : variables.keySet()) {
            try {
                TriggerVariableValueDto variableValue = variables.get(variableName);
                if (variableValue.isLocal()) {
                    commandBuilder.setVariableLocal(variableName, (Object)variableValue.toTypedValue(this.engine, this.objectMapper));
                    continue;
                }
                commandBuilder.setVariable(variableName, (Object)variableValue.toTypedValue(this.engine, this.objectMapper));
            }
            catch (RestException e) {
                String errorMessage = String.format("Cannot %s case instance %s due to invalid variable %s: %s", transition, this.caseInstanceId, variableName, e.getMessage());
                throw new RestException(e.getStatus(), (Exception)((Object)e), errorMessage);
            }
        }
    }

    protected void initializeCommandWithDeletions(CaseExecutionCommandBuilder commandBuilder, List<VariableNameDto> deletions, String transition) {
        for (VariableNameDto variableName : deletions) {
            if (variableName.isLocal()) {
                commandBuilder.removeVariableLocal(variableName.getName());
                continue;
            }
            commandBuilder.removeVariable(variableName.getName());
        }
    }

    public VariableResource getVariablesResource() {
        return new CaseExecutionVariablesResource(this.engine, this.caseInstanceId, this.objectMapper);
    }
}

