/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.scripting.engine.Resolver;
import org.camunda.bpm.engine.impl.scripting.engine.ResolverFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;

public class SpringBeansResolverFactory
implements ResolverFactory,
Resolver {
    protected static Logger LOG = Logger.getLogger(SpringBeansResolverFactory.class.getName());
    protected static String SCOPE_NOT_ACTIVE_EXCEPTION = "org.springframework.beans.factory.support.ScopeNotActiveException";
    private ApplicationContext applicationContext;
    private Set<String> keySet;

    public SpringBeansResolverFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        String[] beannames = applicationContext.getBeanDefinitionNames();
        this.keySet = new HashSet<String>(Arrays.asList(beannames));
    }

    public Resolver createResolver(VariableScope variableScope) {
        return this;
    }

    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.keySet.contains((String)key);
        }
        return false;
    }

    public Object get(Object key) {
        if (key instanceof String) {
            try {
                return this.applicationContext.getBean((String)key);
            }
            catch (BeanCreationException ex) {
                if (SCOPE_NOT_ACTIVE_EXCEPTION.equals(((Object)((Object)ex)).getClass().getName())) {
                    LOG.info("Bean '" + key + "' cannot be accessed since scope is not active. Instead, null is returned. Full exception message: " + ex.getMessage());
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public Set<String> keySet() {
        return this.keySet;
    }
}

