/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.history.IncidentState;
import org.camunda.bpm.engine.impl.AbstractVariableQueryImpl;
import org.camunda.bpm.engine.impl.HistoricIncidentQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HistoricIncidentQueryImpl
extends AbstractVariableQueryImpl<HistoricIncidentQuery, HistoricIncident>
implements HistoricIncidentQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String incidentType;
    protected String incidentMessage;
    protected String executionId;
    protected String activityId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String causeIncidentId;
    protected String rootCauseIncidentId;
    protected String configuration;
    protected IncidentState incidentState;
    protected String[] tenantIds;
    protected String[] jobDefinitionIds;

    public HistoricIncidentQueryImpl() {
    }

    public HistoricIncidentQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricIncidentQuery incidentId(String incidentId) {
        EnsureUtil.ensureNotNull("incidentId", (Object)incidentId);
        this.id = incidentId;
        return this;
    }

    @Override
    public HistoricIncidentQuery incidentType(String incidentType) {
        EnsureUtil.ensureNotNull("incidentType", (Object)incidentType);
        this.incidentType = incidentType;
        return this;
    }

    @Override
    public HistoricIncidentQuery incidentMessage(String incidentMessage) {
        EnsureUtil.ensureNotNull("incidentMessage", (Object)incidentMessage);
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Override
    public HistoricIncidentQuery executionId(String executionId) {
        EnsureUtil.ensureNotNull("executionId", (Object)executionId);
        this.executionId = executionId;
        return this;
    }

    @Override
    public HistoricIncidentQuery activityId(String activityId) {
        EnsureUtil.ensureNotNull("activityId", (Object)activityId);
        this.activityId = activityId;
        return this;
    }

    @Override
    public HistoricIncidentQuery processInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricIncidentQuery processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoricIncidentQuery causeIncidentId(String causeIncidentId) {
        EnsureUtil.ensureNotNull("causeIncidentId", (Object)causeIncidentId);
        this.causeIncidentId = causeIncidentId;
        return this;
    }

    @Override
    public HistoricIncidentQuery rootCauseIncidentId(String rootCauseIncidentId) {
        EnsureUtil.ensureNotNull("rootCauseIncidentId", (Object)rootCauseIncidentId);
        this.rootCauseIncidentId = rootCauseIncidentId;
        return this;
    }

    @Override
    public HistoricIncidentQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        return this;
    }

    @Override
    public HistoricIncidentQuery configuration(String configuration) {
        EnsureUtil.ensureNotNull("configuration", (Object)configuration);
        this.configuration = configuration;
        return this;
    }

    @Override
    public HistoricIncidentQuery jobDefinitionIdIn(String ... jobDefinitionIds) {
        EnsureUtil.ensureNotNull("jobDefinitionIds", jobDefinitionIds);
        this.jobDefinitionIds = jobDefinitionIds;
        return this;
    }

    @Override
    public HistoricIncidentQuery open() {
        if (this.incidentState != null) {
            throw new ProcessEngineException("Already querying for incident state <" + this.incidentState + ">");
        }
        this.incidentState = IncidentState.DEFAULT;
        return this;
    }

    @Override
    public HistoricIncidentQuery resolved() {
        if (this.incidentState != null) {
            throw new ProcessEngineException("Already querying for incident state <" + this.incidentState + ">");
        }
        this.incidentState = IncidentState.RESOLVED;
        return this;
    }

    @Override
    public HistoricIncidentQuery deleted() {
        if (this.incidentState != null) {
            throw new ProcessEngineException("Already querying for incident state <" + this.incidentState + ">");
        }
        this.incidentState = IncidentState.DELETED;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByIncidentId() {
        this.orderBy(HistoricIncidentQueryProperty.INCIDENT_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByIncidentMessage() {
        this.orderBy(HistoricIncidentQueryProperty.INCIDENT_MESSAGE);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByCreateTime() {
        this.orderBy(HistoricIncidentQueryProperty.INCIDENT_CREATE_TIME);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByEndTime() {
        this.orderBy(HistoricIncidentQueryProperty.INCIDENT_END_TIME);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByIncidentType() {
        this.orderBy(HistoricIncidentQueryProperty.INCIDENT_TYPE);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByExecutionId() {
        this.orderBy(HistoricIncidentQueryProperty.EXECUTION_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByActivityId() {
        this.orderBy(HistoricIncidentQueryProperty.ACTIVITY_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByProcessInstanceId() {
        this.orderBy(HistoricIncidentQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByProcessDefinitionId() {
        this.orderBy(HistoricIncidentQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByCauseIncidentId() {
        this.orderBy(HistoricIncidentQueryProperty.CAUSE_INCIDENT_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByRootCauseIncidentId() {
        this.orderBy(HistoricIncidentQueryProperty.ROOT_CAUSE_INCIDENT_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByConfiguration() {
        this.orderBy(HistoricIncidentQueryProperty.CONFIGURATION);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByIncidentState() {
        this.orderBy(HistoricIncidentQueryProperty.INCIDENT_STATE);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByTenantId() {
        return (HistoricIncidentQuery)this.orderBy(HistoricIncidentQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricIncidentManager().findHistoricIncidentCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricIncident> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getHistoricIncidentManager().findHistoricIncidentByQueryCriteria(this, page);
    }

    public String getId() {
        return this.id;
    }

    public String getIncidentType() {
        return this.incidentType;
    }

    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getCauseIncidentId() {
        return this.causeIncidentId;
    }

    public String getRootCauseIncidentId() {
        return this.rootCauseIncidentId;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public IncidentState getIncidentState() {
        return this.incidentState;
    }
}

