/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.cmd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.batch.AbstractIDBasedBatchCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricDecisionInstancesBatchCmd
extends AbstractIDBasedBatchCmd<Batch> {
    protected List<String> historicDecisionInstanceIds;
    protected HistoricDecisionInstanceQuery historicDecisionInstanceQuery;
    protected String deleteReason;

    public DeleteHistoricDecisionInstancesBatchCmd(List<String> historicDecisionInstanceIds, HistoricDecisionInstanceQuery historicDecisionInstanceQuery, String deleteReason) {
        this.historicDecisionInstanceIds = historicDecisionInstanceIds;
        this.historicDecisionInstanceQuery = historicDecisionInstanceQuery;
        this.deleteReason = deleteReason;
    }

    protected List<String> collectHistoricDecisionInstanceIds() {
        HistoricDecisionInstanceQueryImpl decisionInstanceQuery;
        HashSet<String> collectedDecisionInstanceIds = new HashSet<String>();
        List<String> decisionInstanceIds = this.getHistoricDecisionInstanceIds();
        if (decisionInstanceIds != null) {
            collectedDecisionInstanceIds.addAll(decisionInstanceIds);
        }
        if ((decisionInstanceQuery = (HistoricDecisionInstanceQueryImpl)this.historicDecisionInstanceQuery) != null) {
            for (HistoricDecisionInstance hdi : decisionInstanceQuery.list()) {
                collectedDecisionInstanceIds.add(hdi.getId());
            }
        }
        return new ArrayList<String>(collectedDecisionInstanceIds);
    }

    public List<String> getHistoricDecisionInstanceIds() {
        return this.historicDecisionInstanceIds;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        List<String> decisionInstanceIds = this.collectHistoricDecisionInstanceIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicDecisionInstanceIds", decisionInstanceIds);
        this.checkAuthorizations(commandContext, BatchPermissions.CREATE_BATCH_DELETE_DECISION_INSTANCES);
        this.writeUserOperationLog(commandContext, decisionInstanceIds.size());
        BatchEntity batch = this.createBatch(commandContext, decisionInstanceIds);
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        propertyChanges.add(new PropertyChange("deleteReason", null, this.deleteReason));
        commandContext.getOperationLogManager().logDecisionInstanceOperation("DeleteHistory", propertyChanges);
    }

    @Override
    protected BatchConfiguration getAbstractIdsBatchConfiguration(List<String> processInstanceIds) {
        return new BatchConfiguration(processInstanceIds);
    }

    @Override
    protected BatchJobHandler<BatchConfiguration> getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getBatchHandlers().get("historic-decision-instance-deletion");
    }
}

