/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.json;

import camundajar.com.google.gson.JsonArray;
import camundajar.com.google.gson.JsonObject;
import java.util.List;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.QueryEntityRelationCondition;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.QueryPropertyImpl;
import org.camunda.bpm.engine.impl.VariableOrderProperty;
import org.camunda.bpm.engine.impl.json.JsonArrayConverter;
import org.camunda.bpm.engine.impl.json.JsonArrayOfObjectsConverter;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.json.JsonQueryFilteringPropertyConverter;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.query.QueryProperty;

public class JsonQueryOrderingPropertyConverter
extends JsonObjectConverter<QueryOrderingProperty> {
    protected static JsonQueryOrderingPropertyConverter INSTANCE = new JsonQueryOrderingPropertyConverter();
    protected static JsonArrayConverter<List<QueryOrderingProperty>> ARRAY_CONVERTER = new JsonArrayOfObjectsConverter<QueryOrderingProperty>(INSTANCE);
    public static final String RELATION = "relation";
    public static final String QUERY_PROPERTY = "queryProperty";
    public static final String QUERY_PROPERTY_FUNCTION = "queryPropertyFunction";
    public static final String DIRECTION = "direction";
    public static final String RELATION_CONDITIONS = "relationProperties";

    @Override
    public JsonObject toJsonObject(QueryOrderingProperty property) {
        Direction direction;
        JsonObject jsonObject = JsonUtil.createObject();
        JsonUtil.addField(jsonObject, RELATION, property.getRelation());
        QueryProperty queryProperty = property.getQueryProperty();
        if (queryProperty != null) {
            JsonUtil.addField(jsonObject, QUERY_PROPERTY, queryProperty.getName());
            JsonUtil.addField(jsonObject, QUERY_PROPERTY_FUNCTION, queryProperty.getFunction());
        }
        if ((direction = property.getDirection()) != null) {
            JsonUtil.addField(jsonObject, DIRECTION, direction.getName());
        }
        if (property.hasRelationConditions()) {
            JsonArray relationConditionsJson = JsonQueryFilteringPropertyConverter.ARRAY_CONVERTER.toJsonArray(property.getRelationConditions());
            JsonUtil.addField(jsonObject, RELATION_CONDITIONS, relationConditionsJson);
        }
        return jsonObject;
    }

    @Override
    public QueryOrderingProperty toObject(JsonObject jsonObject) {
        String relation = null;
        if (jsonObject.has(RELATION)) {
            relation = JsonUtil.getString(jsonObject, RELATION);
        }
        QueryOrderingProperty property = null;
        property = "variable".equals(relation) ? new VariableOrderProperty() : new QueryOrderingProperty();
        property.setRelation(relation);
        if (jsonObject.has(QUERY_PROPERTY)) {
            String propertyName = JsonUtil.getString(jsonObject, QUERY_PROPERTY);
            String propertyFunction = null;
            if (jsonObject.has(QUERY_PROPERTY_FUNCTION)) {
                propertyFunction = JsonUtil.getString(jsonObject, QUERY_PROPERTY_FUNCTION);
            }
            QueryPropertyImpl queryProperty = new QueryPropertyImpl(propertyName, propertyFunction);
            property.setQueryProperty(queryProperty);
        }
        if (jsonObject.has(DIRECTION)) {
            String direction = JsonUtil.getString(jsonObject, DIRECTION);
            property.setDirection(Direction.findByName(direction));
        }
        if (jsonObject.has(RELATION_CONDITIONS)) {
            List<QueryEntityRelationCondition> relationConditions = JsonQueryFilteringPropertyConverter.ARRAY_CONVERTER.toObject(JsonUtil.getArray(jsonObject, RELATION_CONDITIONS));
            property.setRelationConditions(relationConditions);
        }
        return property;
    }
}

