/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.json;

import camundajar.com.google.gson.JsonObject;
import java.util.List;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.json.MigrationPlanJsonConverter;
import org.camunda.bpm.engine.impl.migration.batch.MigrationBatchConfiguration;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public class MigrationBatchConfigurationJsonConverter
extends JsonObjectConverter<MigrationBatchConfiguration> {
    public static final MigrationBatchConfigurationJsonConverter INSTANCE = new MigrationBatchConfigurationJsonConverter();
    public static final String MIGRATION_PLAN = "migrationPlan";
    public static final String PROCESS_INSTANCE_IDS = "processInstanceIds";
    public static final String SKIP_LISTENERS = "skipListeners";
    public static final String SKIP_IO_MAPPINGS = "skipIoMappings";

    @Override
    public JsonObject toJsonObject(MigrationBatchConfiguration configuration) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addField(json, MIGRATION_PLAN, MigrationPlanJsonConverter.INSTANCE, configuration.getMigrationPlan());
        JsonUtil.addListField(json, PROCESS_INSTANCE_IDS, configuration.getIds());
        JsonUtil.addField(json, SKIP_LISTENERS, configuration.isSkipCustomListeners());
        JsonUtil.addField(json, SKIP_IO_MAPPINGS, configuration.isSkipIoMappings());
        return json;
    }

    @Override
    public MigrationBatchConfiguration toObject(JsonObject json) {
        MigrationBatchConfiguration configuration = new MigrationBatchConfiguration(this.readProcessInstanceIds(json));
        configuration.setMigrationPlan(JsonUtil.asJavaObject(JsonUtil.getObject(json, MIGRATION_PLAN), MigrationPlanJsonConverter.INSTANCE));
        configuration.setSkipCustomListeners(JsonUtil.getBoolean(json, SKIP_LISTENERS));
        configuration.setSkipIoMappings(JsonUtil.getBoolean(json, SKIP_IO_MAPPINGS));
        return configuration;
    }

    protected List<String> readProcessInstanceIds(JsonObject jsonObject) {
        return JsonUtil.asStringList(JsonUtil.getArray(jsonObject, PROCESS_INSTANCE_IDS));
    }
}

