/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.metrics.reporter;

import java.util.Timer;
import java.util.TimerTask;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.metrics.MetricsRegistry;
import org.camunda.bpm.engine.impl.metrics.reporter.MetricsCollectionTask;
import org.camunda.bpm.engine.impl.persistence.entity.MeterLogEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class DbMetricsReporter {
    protected MetricsRegistry metricsRegistry;
    protected CommandExecutor commandExecutor;
    protected String reporterId;
    protected long reportingIntervalInSeconds = 900L;
    protected MetricsCollectionTask metricsCollectionTask;
    private Timer timer;

    public DbMetricsReporter(MetricsRegistry metricsRegistry, CommandExecutor commandExecutor) {
        this.metricsRegistry = metricsRegistry;
        this.commandExecutor = commandExecutor;
        this.initMetricsCollectionTask();
    }

    protected void initMetricsCollectionTask() {
        this.metricsCollectionTask = new MetricsCollectionTask(this.metricsRegistry, this.commandExecutor);
    }

    public void start() {
        this.timer = new Timer("Camunda Metrics Reporter", true);
        long reportingIntervalInMillis = this.reportingIntervalInSeconds * 1000L;
        this.timer.scheduleAtFixedRate((TimerTask)this.metricsCollectionTask, reportingIntervalInMillis, reportingIntervalInMillis);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            this.reportNow();
        }
    }

    public void reportNow() {
        if (this.metricsCollectionTask != null) {
            this.metricsCollectionTask.run();
        }
    }

    public void reportValueAtOnce(final String name, final long value) {
        this.commandExecutor.execute(new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                commandContext.getMeterLogManager().insert(new MeterLogEntity(name, DbMetricsReporter.this.reporterId, value, ClockUtil.getCurrentTime()));
                return null;
            }
        });
    }

    public long getReportingIntervalInSeconds() {
        return this.reportingIntervalInSeconds;
    }

    public void setReportingIntervalInSeconds(long reportingIntervalInSeconds) {
        this.reportingIntervalInSeconds = reportingIntervalInSeconds;
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public MetricsCollectionTask getMetricsCollectionTask() {
        return this.metricsCollectionTask;
    }

    public void setMetricsCollectionTask(MetricsCollectionTask metricsCollectionTask) {
        this.metricsCollectionTask = metricsCollectionTask;
    }

    public void setReporterId(String reporterId) {
        this.reporterId = reporterId;
        if (this.metricsCollectionTask != null) {
            this.metricsCollectionTask.setReporter(reporterId);
        }
    }
}

