/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.PreUndeploy;
import org.camunda.bpm.container.impl.deployment.util.InjectionUtil;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.DeploymentOperationStep;
import org.camunda.bpm.engine.ProcessEngineException;

public class PreUndeployInvocationStep
extends DeploymentOperationStep {
    @Override
    public String getName() {
        return "Invoking @PreUndeploy";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        Class<?> paClass = processApplication.getClass();
        Method preUndeployMethod = InjectionUtil.detectAnnotatedMethod(paClass, PreUndeploy.class);
        if (preUndeployMethod == null) {
            if (this.LOGGER.isLoggable(Level.FINE)) {
                this.LOGGER.fine("Found no @PreUndeploy annotated method.");
            }
            return;
        }
        if (this.LOGGER.isLoggable(Level.FINE)) {
            this.LOGGER.fine("Found @PreUndeploy annotated method: " + preUndeployMethod.getName());
        }
        Object[] injections = InjectionUtil.resolveInjections(operationContext, preUndeployMethod);
        try {
            preUndeployMethod.invoke((Object)processApplication, injections);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessEngineException("IllegalArgumentException while invoking @PreUndeploy method", e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessEngineException("IllegalAccessException while invoking @PreUndeploy method", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ProcessEngineException("Exception while invoking @PreUndeploy method", cause);
        }
    }
}

