/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.management.DeploymentStatistics;
import org.camunda.bpm.engine.management.DeploymentStatisticsQuery;

public class DeploymentStatisticsQueryImpl
extends AbstractQuery<DeploymentStatisticsQuery, DeploymentStatistics>
implements DeploymentStatisticsQuery {
    protected static final long serialVersionUID = 1L;
    protected boolean includeFailedJobs = false;
    protected boolean includeIncidents = false;
    protected String includeIncidentsForType;

    public DeploymentStatisticsQueryImpl(CommandExecutor executor) {
        super(executor);
    }

    @Override
    public DeploymentStatisticsQuery includeFailedJobs() {
        this.includeFailedJobs = true;
        return this;
    }

    @Override
    public DeploymentStatisticsQuery includeIncidents() {
        this.includeIncidents = true;
        return this;
    }

    @Override
    public DeploymentStatisticsQuery includeIncidentsForType(String incidentType) {
        this.includeIncidentsForType = incidentType;
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getStatisticsManager().getStatisticsCountGroupedByDeployment(this);
    }

    @Override
    public List<DeploymentStatistics> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getStatisticsManager().getStatisticsGroupedByDeployment(this, page);
    }

    public boolean isFailedJobsToInclude() {
        return this.includeFailedJobs;
    }

    public boolean isIncidentsToInclude() {
        return this.includeIncidents || this.includeIncidentsForType != null;
    }

    @Override
    protected void checkQueryOk() {
        super.checkQueryOk();
        if (this.includeIncidents && this.includeIncidentsForType != null) {
            throw new ProcessEngineException("Invalid query: It is not possible to use includeIncident() and includeIncidentForType() to execute one query.");
        }
    }
}

