/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.event;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.bpmn.helper.ScopeUtil;
import org.camunda.bpm.engine.impl.event.EventHandler;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class CompensationEventHandler
implements EventHandler {
    public static final String EVENT_HANDLER_TYPE = "compensate";

    @Override
    public String getEventHandlerType() {
        return EVENT_HANDLER_TYPE;
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        String configuration = eventSubscription.getConfiguration();
        EnsureUtil.ensureNotNull("Compensating execution not set for compensate event subscription with id " + eventSubscription.getId(), "configuration", (Object)configuration);
        ExecutionEntity compensatingExecution = commandContext.getExecutionManager().findExecutionById(configuration);
        ActivityImpl compensationHandler = eventSubscription.getActivity();
        if ((compensationHandler.getProperty("isForCompensation") == null || !((Boolean)compensationHandler.getProperty("isForCompensation")).booleanValue()) && compensationHandler.isScope()) {
            compensatingExecution.setActive(true);
            List<CompensateEventSubscriptionEntity> eventsForThisScope = compensatingExecution.getCompensateEventSubscriptions();
            ScopeUtil.throwCompensationEvent(eventsForThisScope, compensatingExecution, false);
        } else {
            try {
                compensatingExecution.setActivity(compensationHandler);
                compensatingExecution.performOperation(AtomicOperation.ACTIVITY_START);
            }
            catch (Exception e) {
                throw new ProcessEngineException("Error while handling compensation event " + eventSubscription, e);
            }
        }
    }
}

