/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.util.ClassNameUtil;

public class LogInterceptor
extends CommandInterceptor {
    private static Logger log = Logger.getLogger(LogInterceptor.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Command<T> command) {
        if (!log.isLoggable(Level.FINE)) {
            return this.next.execute(command);
        }
        log.fine("                                                                                                    ");
        log.fine("--- starting " + ClassNameUtil.getClassNameWithoutPackage(command) + " --------------------------------------------------------");
        try {
            T t = this.next.execute(command);
            return t;
        }
        finally {
            log.fine("--- " + ClassNameUtil.getClassNameWithoutPackage(command) + " finished --------------------------------------------------------");
            log.fine("                                                                                                    ");
        }
    }
}

