/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.impl.HistoricDetailQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.history.event.HistoricDetailEventEntity;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HistoricDetailManager
extends AbstractHistoricManager {
    public void deleteHistoricDetailsByProcessInstanceId(String historicProcessInstanceId) {
        this.deleteHistoricDetailsByProcessCaseInstanceId(historicProcessInstanceId, null);
    }

    public void deleteHistoricDetailsByCaseInstanceId(String historicCaseInstanceId) {
        this.deleteHistoricDetailsByProcessCaseInstanceId(null, historicCaseInstanceId);
    }

    public void deleteHistoricDetailsByProcessCaseInstanceId(String historicProcessInstanceId, String historicCaseInstanceId) {
        EnsureUtil.ensureOnlyOneNotNull("Only the process instance or case instance id should be set", historicProcessInstanceId, historicCaseInstanceId);
        if (this.isHistoryEnabled()) {
            List<HistoricDetail> historicDetails = historicProcessInstanceId != null ? this.findHistoricDetailsByProcessInstanceId(historicProcessInstanceId) : this.findHistoricDetailsByCaseInstanceId(historicCaseInstanceId);
            for (HistoricDetail historicDetail : historicDetails) {
                ((HistoricDetailEventEntity)((Object)historicDetail)).delete();
            }
            List<HistoricDetailEventEntity> cachedHistoricDetails = this.getDbEntityManager().getCachedEntitiesByType(HistoricDetailEventEntity.class);
            for (HistoricDetailEventEntity historicDetail : cachedHistoricDetails) {
                if ((historicProcessInstanceId == null || !historicProcessInstanceId.equals(historicDetail.getProcessInstanceId())) && (historicCaseInstanceId == null || !historicCaseInstanceId.equals(historicDetail.getCaseInstanceId()))) continue;
                historicDetail.delete();
            }
        }
    }

    public List<HistoricDetail> findHistoricDetailsByProcessInstanceId(String processInstanceId) {
        return this.getDbEntityManager().selectList("selectHistoricDetailsByProcessInstanceId", processInstanceId);
    }

    public List<HistoricDetail> findHistoricDetailsByCaseInstanceId(String caseInstanceId) {
        return this.getDbEntityManager().selectList("selectHistoricDetailsByCaseInstanceId", caseInstanceId);
    }

    public long findHistoricDetailCountByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricDetailCountByQueryCriteria", historicVariableUpdateQuery);
    }

    public List<HistoricDetail> findHistoricDetailsByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery, Page page) {
        return this.getDbEntityManager().selectList("selectHistoricDetailsByQueryCriteria", historicVariableUpdateQuery, page);
    }

    public void deleteHistoricDetailsByTaskId(String taskId) {
        if (this.isHistoryEnabled()) {
            List<HistoricDetail> historicDetails = this.findHistoricDetailsByTaskId(taskId);
            for (HistoricDetail historicDetail : historicDetails) {
                ((HistoricDetailEventEntity)((Object)historicDetail)).delete();
            }
            List<HistoricDetailEventEntity> cachedHistoricDetails = this.getDbEntityManager().getCachedEntitiesByType(HistoricDetailEventEntity.class);
            for (HistoricDetailEventEntity historicDetail : cachedHistoricDetails) {
                if (!taskId.equals(historicDetail.getTaskId())) continue;
                historicDetail.delete();
            }
        }
    }

    public List<HistoricDetail> findHistoricDetailsByTaskId(String taskId) {
        return this.getDbEntityManager().selectList("selectHistoricDetailsByTaskId", taskId);
    }
}

