/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.camunda.bpm.engine.ScriptEvaluationException;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;

public abstract class DynamicExecutableScript
extends ExecutableScript {
    protected final Expression scriptExpression;

    protected DynamicExecutableScript(Expression scriptExpression, String language) {
        super(language);
        this.scriptExpression = scriptExpression;
    }

    @Override
    public Object execute(ScriptEngine scriptEngine, VariableScope variableScope, Bindings bindings) {
        String source = this.getScriptSource(variableScope);
        try {
            return scriptEngine.eval(source, bindings);
        }
        catch (ScriptException e) {
            throw new ScriptEvaluationException("Unable to evaluate script: " + e.getMessage(), e);
        }
    }

    protected String evaluateExpression(VariableScope variableScope) {
        return (String)this.scriptExpression.getValue(variableScope);
    }

    public abstract String getScriptSource(VariableScope var1);
}

