/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.scripting.SourceExecutableScript;
import org.camunda.bpm.engine.impl.util.ResourceUtil;

public class ResourceExecutableScript
extends SourceExecutableScript {
    protected String scriptResource;

    public ResourceExecutableScript(String language, String scriptResource) {
        super(language, null);
        this.scriptResource = scriptResource;
    }

    @Override
    public Object execute(ScriptEngine engine, VariableScope variableScope, Bindings bindings) {
        if (this.scriptSource == null) {
            this.loadScriptSource();
        }
        return super.execute(engine, variableScope, bindings);
    }

    protected synchronized void loadScriptSource() {
        if (this.getScriptSource() == null) {
            DeploymentEntity deployment = Context.getCoreExecutionContext().getDeployment();
            String source = ResourceUtil.loadResourceContent(this.scriptResource, deployment);
            this.setScriptSource(source);
        }
    }
}

