/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer;

import org.camunda.bpm.engine.impl.core.variable.value.UntypedValueImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.BytesValue;

public class ByteArrayValueSerializer
extends PrimitiveValueSerializer<BytesValue> {
    public ByteArrayValueSerializer() {
        super(ValueType.BYTES);
    }

    @Override
    public BytesValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return Variables.byteArrayValue((byte[])untypedValue.getValue());
    }

    @Override
    public BytesValue readValue(ValueFields valueFields) {
        return Variables.byteArrayValue(ByteArrayValueSerializer.getBytes(valueFields));
    }

    @Override
    public void writeValue(BytesValue variableValue, ValueFields valueFields) {
        ByteArrayValueSerializer.setBytes(valueFields, (byte[])variableValue.getValue());
    }

    public static byte[] getBytes(ValueFields valueFields) {
        byte[] byteArray = null;
        if (valueFields.getByteArrayValue() != null) {
            byteArray = valueFields.getByteArrayValue().getBytes();
        }
        return byteArray;
    }

    public static void setBytes(ValueFields valueFields, byte[] bytes) {
        ByteArrayEntity byteArray = valueFields.getByteArrayValue();
        if (byteArray == null) {
            valueFields.setByteArrayValue(bytes);
        } else {
            byteArray.setBytes(bytes);
        }
    }
}

